// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Vpn device configuration script generation parameters.
 */
@Fluent
public final class VpnDeviceScriptParameters implements JsonSerializable<VpnDeviceScriptParameters> {
    /*
     * The vendor for the vpn device.
     */
    private String vendor;

    /*
     * The device family for the vpn device.
     */
    private String deviceFamily;

    /*
     * The firmware version for the vpn device.
     */
    private String firmwareVersion;

    /**
     * Creates an instance of VpnDeviceScriptParameters class.
     */
    public VpnDeviceScriptParameters() {
    }

    /**
     * Get the vendor property: The vendor for the vpn device.
     * 
     * @return the vendor value.
     */
    public String vendor() {
        return this.vendor;
    }

    /**
     * Set the vendor property: The vendor for the vpn device.
     * 
     * @param vendor the vendor value to set.
     * @return the VpnDeviceScriptParameters object itself.
     */
    public VpnDeviceScriptParameters withVendor(String vendor) {
        this.vendor = vendor;
        return this;
    }

    /**
     * Get the deviceFamily property: The device family for the vpn device.
     * 
     * @return the deviceFamily value.
     */
    public String deviceFamily() {
        return this.deviceFamily;
    }

    /**
     * Set the deviceFamily property: The device family for the vpn device.
     * 
     * @param deviceFamily the deviceFamily value to set.
     * @return the VpnDeviceScriptParameters object itself.
     */
    public VpnDeviceScriptParameters withDeviceFamily(String deviceFamily) {
        this.deviceFamily = deviceFamily;
        return this;
    }

    /**
     * Get the firmwareVersion property: The firmware version for the vpn device.
     * 
     * @return the firmwareVersion value.
     */
    public String firmwareVersion() {
        return this.firmwareVersion;
    }

    /**
     * Set the firmwareVersion property: The firmware version for the vpn device.
     * 
     * @param firmwareVersion the firmwareVersion value to set.
     * @return the VpnDeviceScriptParameters object itself.
     */
    public VpnDeviceScriptParameters withFirmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("vendor", this.vendor);
        jsonWriter.writeStringField("deviceFamily", this.deviceFamily);
        jsonWriter.writeStringField("firmwareVersion", this.firmwareVersion);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VpnDeviceScriptParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VpnDeviceScriptParameters if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VpnDeviceScriptParameters.
     */
    public static VpnDeviceScriptParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VpnDeviceScriptParameters deserializedVpnDeviceScriptParameters = new VpnDeviceScriptParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("vendor".equals(fieldName)) {
                    deserializedVpnDeviceScriptParameters.vendor = reader.getString();
                } else if ("deviceFamily".equals(fieldName)) {
                    deserializedVpnDeviceScriptParameters.deviceFamily = reader.getString();
                } else if ("firmwareVersion".equals(fieldName)) {
                    deserializedVpnDeviceScriptParameters.firmwareVersion = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVpnDeviceScriptParameters;
        });
    }
}
