// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The VirtualHub Router autoscale configuration.
 */
@Fluent
public final class VirtualRouterAutoScaleConfiguration
    implements JsonSerializable<VirtualRouterAutoScaleConfiguration> {
    /*
     * The minimum number of scale units for VirtualHub Router.
     */
    private Integer minCapacity;

    /**
     * Creates an instance of VirtualRouterAutoScaleConfiguration class.
     */
    public VirtualRouterAutoScaleConfiguration() {
    }

    /**
     * Get the minCapacity property: The minimum number of scale units for VirtualHub Router.
     * 
     * @return the minCapacity value.
     */
    public Integer minCapacity() {
        return this.minCapacity;
    }

    /**
     * Set the minCapacity property: The minimum number of scale units for VirtualHub Router.
     * 
     * @param minCapacity the minCapacity value to set.
     * @return the VirtualRouterAutoScaleConfiguration object itself.
     */
    public VirtualRouterAutoScaleConfiguration withMinCapacity(Integer minCapacity) {
        this.minCapacity = minCapacity;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("minCapacity", this.minCapacity);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualRouterAutoScaleConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualRouterAutoScaleConfiguration if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualRouterAutoScaleConfiguration.
     */
    public static VirtualRouterAutoScaleConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualRouterAutoScaleConfiguration deserializedVirtualRouterAutoScaleConfiguration
                = new VirtualRouterAutoScaleConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("minCapacity".equals(fieldName)) {
                    deserializedVirtualRouterAutoScaleConfiguration.minCapacity
                        = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualRouterAutoScaleConfiguration;
        });
    }
}
