// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Represent the current migration phase of gateway.
 */
public final class VirtualNetworkGatewayMigrationPhase
    extends ExpandableStringEnum<VirtualNetworkGatewayMigrationPhase> {
    /**
     * Static value None for VirtualNetworkGatewayMigrationPhase.
     */
    public static final VirtualNetworkGatewayMigrationPhase NONE = fromString("None");

    /**
     * Static value Prepare for VirtualNetworkGatewayMigrationPhase.
     */
    public static final VirtualNetworkGatewayMigrationPhase PREPARE = fromString("Prepare");

    /**
     * Static value PrepareSucceeded for VirtualNetworkGatewayMigrationPhase.
     */
    public static final VirtualNetworkGatewayMigrationPhase PREPARE_SUCCEEDED = fromString("PrepareSucceeded");

    /**
     * Static value Execute for VirtualNetworkGatewayMigrationPhase.
     */
    public static final VirtualNetworkGatewayMigrationPhase EXECUTE = fromString("Execute");

    /**
     * Static value ExecuteSucceeded for VirtualNetworkGatewayMigrationPhase.
     */
    public static final VirtualNetworkGatewayMigrationPhase EXECUTE_SUCCEEDED = fromString("ExecuteSucceeded");

    /**
     * Static value Commit for VirtualNetworkGatewayMigrationPhase.
     */
    public static final VirtualNetworkGatewayMigrationPhase COMMIT = fromString("Commit");

    /**
     * Static value CommitSucceeded for VirtualNetworkGatewayMigrationPhase.
     */
    public static final VirtualNetworkGatewayMigrationPhase COMMIT_SUCCEEDED = fromString("CommitSucceeded");

    /**
     * Static value AbortSucceeded for VirtualNetworkGatewayMigrationPhase.
     */
    public static final VirtualNetworkGatewayMigrationPhase ABORT_SUCCEEDED = fromString("AbortSucceeded");

    /**
     * Static value Abort for VirtualNetworkGatewayMigrationPhase.
     */
    public static final VirtualNetworkGatewayMigrationPhase ABORT = fromString("Abort");

    /**
     * Creates a new instance of VirtualNetworkGatewayMigrationPhase value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public VirtualNetworkGatewayMigrationPhase() {
    }

    /**
     * Creates or finds a VirtualNetworkGatewayMigrationPhase from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding VirtualNetworkGatewayMigrationPhase.
     */
    public static VirtualNetworkGatewayMigrationPhase fromString(String name) {
        return fromString(name, VirtualNetworkGatewayMigrationPhase.class);
    }

    /**
     * Gets known VirtualNetworkGatewayMigrationPhase values.
     * 
     * @return known VirtualNetworkGatewayMigrationPhase values.
     */
    public static Collection<VirtualNetworkGatewayMigrationPhase> values() {
        return values(VirtualNetworkGatewayMigrationPhase.class);
    }
}
