// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Network Virtual Appliance NIC properties.
 */
@Immutable
public final class VirtualApplianceNicProperties implements JsonSerializable<VirtualApplianceNicProperties> {
    /*
     * NIC type - PublicNic, PrivateNic, or AdditionalNic; AdditionalPrivateNic and AdditionalPublicNic are only
     * supported for NVAs deployed in VNets.
     */
    private NicTypeInResponse nicType;

    /*
     * NIC name.
     */
    private String name;

    /*
     * Public IP address.
     */
    private String publicIpAddress;

    /*
     * Private IP address.
     */
    private String privateIpAddress;

    /*
     * Instance on which nic is attached.
     */
    private String instanceName;

    /**
     * Creates an instance of VirtualApplianceNicProperties class.
     */
    public VirtualApplianceNicProperties() {
    }

    /**
     * Get the nicType property: NIC type - PublicNic, PrivateNic, or AdditionalNic; AdditionalPrivateNic and
     * AdditionalPublicNic are only supported for NVAs deployed in VNets.
     * 
     * @return the nicType value.
     */
    public NicTypeInResponse nicType() {
        return this.nicType;
    }

    /**
     * Get the name property: NIC name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the publicIpAddress property: Public IP address.
     * 
     * @return the publicIpAddress value.
     */
    public String publicIpAddress() {
        return this.publicIpAddress;
    }

    /**
     * Get the privateIpAddress property: Private IP address.
     * 
     * @return the privateIpAddress value.
     */
    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    /**
     * Get the instanceName property: Instance on which nic is attached.
     * 
     * @return the instanceName value.
     */
    public String instanceName() {
        return this.instanceName;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualApplianceNicProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualApplianceNicProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualApplianceNicProperties.
     */
    public static VirtualApplianceNicProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualApplianceNicProperties deserializedVirtualApplianceNicProperties
                = new VirtualApplianceNicProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("nicType".equals(fieldName)) {
                    deserializedVirtualApplianceNicProperties.nicType
                        = NicTypeInResponse.fromString(reader.getString());
                } else if ("name".equals(fieldName)) {
                    deserializedVirtualApplianceNicProperties.name = reader.getString();
                } else if ("publicIpAddress".equals(fieldName)) {
                    deserializedVirtualApplianceNicProperties.publicIpAddress = reader.getString();
                } else if ("privateIpAddress".equals(fieldName)) {
                    deserializedVirtualApplianceNicProperties.privateIpAddress = reader.getString();
                } else if ("instanceName".equals(fieldName)) {
                    deserializedVirtualApplianceNicProperties.instanceName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualApplianceNicProperties;
        });
    }
}
