// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Ddos Custom Policy traffic detection rule.
 */
@Fluent
public final class TrafficDetectionRule implements JsonSerializable<TrafficDetectionRule> {
    /*
     * The traffic type (one of Tcp, Udp, TcpSyn) that the detection rule will be applied upon.
     */
    private DdosTrafficType trafficType;

    /*
     * The customized packets per second threshold.
     */
    private Integer packetsPerSecond;

    /**
     * Creates an instance of TrafficDetectionRule class.
     */
    public TrafficDetectionRule() {
    }

    /**
     * Get the trafficType property: The traffic type (one of Tcp, Udp, TcpSyn) that the detection rule will be applied
     * upon.
     * 
     * @return the trafficType value.
     */
    public DdosTrafficType trafficType() {
        return this.trafficType;
    }

    /**
     * Set the trafficType property: The traffic type (one of Tcp, Udp, TcpSyn) that the detection rule will be applied
     * upon.
     * 
     * @param trafficType the trafficType value to set.
     * @return the TrafficDetectionRule object itself.
     */
    public TrafficDetectionRule withTrafficType(DdosTrafficType trafficType) {
        this.trafficType = trafficType;
        return this;
    }

    /**
     * Get the packetsPerSecond property: The customized packets per second threshold.
     * 
     * @return the packetsPerSecond value.
     */
    public Integer packetsPerSecond() {
        return this.packetsPerSecond;
    }

    /**
     * Set the packetsPerSecond property: The customized packets per second threshold.
     * 
     * @param packetsPerSecond the packetsPerSecond value to set.
     * @return the TrafficDetectionRule object itself.
     */
    public TrafficDetectionRule withPacketsPerSecond(Integer packetsPerSecond) {
        this.packetsPerSecond = packetsPerSecond;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("trafficType", this.trafficType == null ? null : this.trafficType.toString());
        jsonWriter.writeNumberField("packetsPerSecond", this.packetsPerSecond);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TrafficDetectionRule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TrafficDetectionRule if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the TrafficDetectionRule.
     */
    public static TrafficDetectionRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TrafficDetectionRule deserializedTrafficDetectionRule = new TrafficDetectionRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("trafficType".equals(fieldName)) {
                    deserializedTrafficDetectionRule.trafficType = DdosTrafficType.fromString(reader.getString());
                } else if ("packetsPerSecond".equals(fieldName)) {
                    deserializedTrafficDetectionRule.packetsPerSecond = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTrafficDetectionRule;
        });
    }
}
