// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Resource
 * 
 * Common fields that are returned in the response for all Azure Resource Manager resources.
 */
@Immutable
public class SecurityPerimeterResource extends ProxyResource {
    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SecurityPerimeterSystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of SecurityPerimeterResource class.
     */
    public SecurityPerimeterResource() {
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SecurityPerimeterSystemData systemData() {
        return this.systemData;
    }

    /**
     * Set the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @param systemData the systemData value to set.
     * @return the SecurityPerimeterResource object itself.
     */
    SecurityPerimeterResource withSystemData(SecurityPerimeterSystemData systemData) {
        this.systemData = systemData;
        return this;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (systemData() != null) {
            systemData().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SecurityPerimeterResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SecurityPerimeterResource if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SecurityPerimeterResource.
     */
    public static SecurityPerimeterResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecurityPerimeterResource deserializedSecurityPerimeterResource = new SecurityPerimeterResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSecurityPerimeterResource.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedSecurityPerimeterResource.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedSecurityPerimeterResource.type = reader.getString();
                } else if ("systemData".equals(fieldName)) {
                    deserializedSecurityPerimeterResource.systemData = SecurityPerimeterSystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSecurityPerimeterResource;
        });
    }
}
