// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Route table usage mode defines which route table will be used by the configuration. If not defined, this will default
 * to 'ManagedOnly'.
 */
public final class RouteTableUsageMode extends ExpandableStringEnum<RouteTableUsageMode> {
    /**
     * Static value ManagedOnly for RouteTableUsageMode.
     */
    public static final RouteTableUsageMode MANAGED_ONLY = fromString("ManagedOnly");

    /**
     * Static value UseExisting for RouteTableUsageMode.
     */
    public static final RouteTableUsageMode USE_EXISTING = fromString("UseExisting");

    /**
     * Creates a new instance of RouteTableUsageMode value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public RouteTableUsageMode() {
    }

    /**
     * Creates or finds a RouteTableUsageMode from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding RouteTableUsageMode.
     */
    public static RouteTableUsageMode fromString(String name) {
        return fromString(name, RouteTableUsageMode.class);
    }

    /**
     * Gets known RouteTableUsageMode values.
     * 
     * @return known RouteTableUsageMode values.
     */
    public static Collection<RouteTableUsageMode> values() {
        return values(RouteTableUsageMode.class);
    }
}
