// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The request for ReserveCloudServicePublicIpAddressOperation.
 */
@Fluent
public final class ReserveCloudServicePublicIpAddressRequest
    implements JsonSerializable<ReserveCloudServicePublicIpAddressRequest> {
    /*
     * When true, reverts from Static to Dynamic allocation (undo reservation).
     */
    private IsRollback isRollback;

    /**
     * Creates an instance of ReserveCloudServicePublicIpAddressRequest class.
     */
    public ReserveCloudServicePublicIpAddressRequest() {
    }

    /**
     * Get the isRollback property: When true, reverts from Static to Dynamic allocation (undo reservation).
     * 
     * @return the isRollback value.
     */
    public IsRollback isRollback() {
        return this.isRollback;
    }

    /**
     * Set the isRollback property: When true, reverts from Static to Dynamic allocation (undo reservation).
     * 
     * @param isRollback the isRollback value to set.
     * @return the ReserveCloudServicePublicIpAddressRequest object itself.
     */
    public ReserveCloudServicePublicIpAddressRequest withIsRollback(IsRollback isRollback) {
        this.isRollback = isRollback;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (isRollback() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property isRollback in model ReserveCloudServicePublicIpAddressRequest"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ReserveCloudServicePublicIpAddressRequest.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("isRollback", this.isRollback == null ? null : this.isRollback.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ReserveCloudServicePublicIpAddressRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ReserveCloudServicePublicIpAddressRequest if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ReserveCloudServicePublicIpAddressRequest.
     */
    public static ReserveCloudServicePublicIpAddressRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ReserveCloudServicePublicIpAddressRequest deserializedReserveCloudServicePublicIpAddressRequest
                = new ReserveCloudServicePublicIpAddressRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("isRollback".equals(fieldName)) {
                    deserializedReserveCloudServicePublicIpAddressRequest.isRollback
                        = IsRollback.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedReserveCloudServicePublicIpAddressRequest;
        });
    }
}
