// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents the Reachability Analysis Run properties.
 */
@Fluent
public final class ReachabilityAnalysisRunProperties implements JsonSerializable<ReachabilityAnalysisRunProperties> {
    /*
     * The description property.
     */
    private String description;

    /*
     * Id of the intent resource to run analysis on.
     */
    private String intentId;

    /*
     * Intent information.
     */
    private IntentContent intentContent;

    /*
     * The analysisResult property.
     */
    private String analysisResult;

    /*
     * The errorMessage property.
     */
    private String errorMessage;

    /*
     * Provisioning states of a resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of ReachabilityAnalysisRunProperties class.
     */
    public ReachabilityAnalysisRunProperties() {
    }

    /**
     * Get the description property: The description property.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The description property.
     * 
     * @param description the description value to set.
     * @return the ReachabilityAnalysisRunProperties object itself.
     */
    public ReachabilityAnalysisRunProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the intentId property: Id of the intent resource to run analysis on.
     * 
     * @return the intentId value.
     */
    public String intentId() {
        return this.intentId;
    }

    /**
     * Set the intentId property: Id of the intent resource to run analysis on.
     * 
     * @param intentId the intentId value to set.
     * @return the ReachabilityAnalysisRunProperties object itself.
     */
    public ReachabilityAnalysisRunProperties withIntentId(String intentId) {
        this.intentId = intentId;
        return this;
    }

    /**
     * Get the intentContent property: Intent information.
     * 
     * @return the intentContent value.
     */
    public IntentContent intentContent() {
        return this.intentContent;
    }

    /**
     * Get the analysisResult property: The analysisResult property.
     * 
     * @return the analysisResult value.
     */
    public String analysisResult() {
        return this.analysisResult;
    }

    /**
     * Get the errorMessage property: The errorMessage property.
     * 
     * @return the errorMessage value.
     */
    public String errorMessage() {
        return this.errorMessage;
    }

    /**
     * Get the provisioningState property: Provisioning states of a resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Set the provisioningState property: Provisioning states of a resource.
     * 
     * @param provisioningState the provisioningState value to set.
     * @return the ReachabilityAnalysisRunProperties object itself.
     */
    public ReachabilityAnalysisRunProperties withProvisioningState(ProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (intentId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property intentId in model ReachabilityAnalysisRunProperties"));
        }
        if (intentContent() != null) {
            intentContent().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ReachabilityAnalysisRunProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("intentId", this.intentId);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("provisioningState",
            this.provisioningState == null ? null : this.provisioningState.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ReachabilityAnalysisRunProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ReachabilityAnalysisRunProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ReachabilityAnalysisRunProperties.
     */
    public static ReachabilityAnalysisRunProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ReachabilityAnalysisRunProperties deserializedReachabilityAnalysisRunProperties
                = new ReachabilityAnalysisRunProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("intentId".equals(fieldName)) {
                    deserializedReachabilityAnalysisRunProperties.intentId = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedReachabilityAnalysisRunProperties.description = reader.getString();
                } else if ("intentContent".equals(fieldName)) {
                    deserializedReachabilityAnalysisRunProperties.intentContent = IntentContent.fromJson(reader);
                } else if ("analysisResult".equals(fieldName)) {
                    deserializedReachabilityAnalysisRunProperties.analysisResult = reader.getString();
                } else if ("errorMessage".equals(fieldName)) {
                    deserializedReachabilityAnalysisRunProperties.errorMessage = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedReachabilityAnalysisRunProperties.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedReachabilityAnalysisRunProperties;
        });
    }
}
