// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Specifies the IP version type for the private IPs of the private endpoint. If not defined, this defaults to IPv4.
 */
public final class PrivateEndpointIpVersionType extends ExpandableStringEnum<PrivateEndpointIpVersionType> {
    /**
     * Static value IPv4 for PrivateEndpointIpVersionType.
     */
    public static final PrivateEndpointIpVersionType IPV4 = fromString("IPv4");

    /**
     * Static value IPv6 for PrivateEndpointIpVersionType.
     */
    public static final PrivateEndpointIpVersionType IPV6 = fromString("IPv6");

    /**
     * Static value DualStack for PrivateEndpointIpVersionType.
     */
    public static final PrivateEndpointIpVersionType DUAL_STACK = fromString("DualStack");

    /**
     * Creates a new instance of PrivateEndpointIpVersionType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public PrivateEndpointIpVersionType() {
    }

    /**
     * Creates or finds a PrivateEndpointIpVersionType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding PrivateEndpointIpVersionType.
     */
    public static PrivateEndpointIpVersionType fromString(String name) {
        return fromString(name, PrivateEndpointIpVersionType.class);
    }

    /**
     * Gets known PrivateEndpointIpVersionType values.
     * 
     * @return known PrivateEndpointIpVersionType values.
     */
    public static Collection<PrivateEndpointIpVersionType> values() {
        return values(PrivateEndpointIpVersionType.class);
    }
}
