// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Specifies input parameters required NVA in VNet interface configuration.
 */
@Fluent
public final class NvaInterfaceConfigurationsProperties
    implements JsonSerializable<NvaInterfaceConfigurationsProperties> {
    /*
     * A subnet resource id where the NIC will be deployed. Each subnet resource uri should be unique.
     */
    private NvaInVnetSubnetReferenceProperties subnet;

    /*
     * Specifies the NIC types for the NVA interface configuration. Allowed values: PrivateNic, PublicNic,
     * AdditionalPrivateNic, AdditionalPublicNic. Only the combination of PrivateNic and PublicNic is currently
     * supported.
     */
    private List<NvaNicType> type;

    /*
     * Specifies the name of the interface. Maximum length is 70 characters.
     */
    private String name;

    /**
     * Creates an instance of NvaInterfaceConfigurationsProperties class.
     */
    public NvaInterfaceConfigurationsProperties() {
    }

    /**
     * Get the subnet property: A subnet resource id where the NIC will be deployed. Each subnet resource uri should be
     * unique.
     * 
     * @return the subnet value.
     */
    public NvaInVnetSubnetReferenceProperties subnet() {
        return this.subnet;
    }

    /**
     * Set the subnet property: A subnet resource id where the NIC will be deployed. Each subnet resource uri should be
     * unique.
     * 
     * @param subnet the subnet value to set.
     * @return the NvaInterfaceConfigurationsProperties object itself.
     */
    public NvaInterfaceConfigurationsProperties withSubnet(NvaInVnetSubnetReferenceProperties subnet) {
        this.subnet = subnet;
        return this;
    }

    /**
     * Get the type property: Specifies the NIC types for the NVA interface configuration. Allowed values: PrivateNic,
     * PublicNic, AdditionalPrivateNic, AdditionalPublicNic. Only the combination of PrivateNic and PublicNic is
     * currently supported.
     * 
     * @return the type value.
     */
    public List<NvaNicType> type() {
        return this.type;
    }

    /**
     * Set the type property: Specifies the NIC types for the NVA interface configuration. Allowed values: PrivateNic,
     * PublicNic, AdditionalPrivateNic, AdditionalPublicNic. Only the combination of PrivateNic and PublicNic is
     * currently supported.
     * 
     * @param type the type value to set.
     * @return the NvaInterfaceConfigurationsProperties object itself.
     */
    public NvaInterfaceConfigurationsProperties withType(List<NvaNicType> type) {
        this.type = type;
        return this;
    }

    /**
     * Get the name property: Specifies the name of the interface. Maximum length is 70 characters.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Specifies the name of the interface. Maximum length is 70 characters.
     * 
     * @param name the name value to set.
     * @return the NvaInterfaceConfigurationsProperties object itself.
     */
    public NvaInterfaceConfigurationsProperties withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (subnet() != null) {
            subnet().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("subnet", this.subnet);
        jsonWriter.writeArrayField("type", this.type,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NvaInterfaceConfigurationsProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NvaInterfaceConfigurationsProperties if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NvaInterfaceConfigurationsProperties.
     */
    public static NvaInterfaceConfigurationsProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NvaInterfaceConfigurationsProperties deserializedNvaInterfaceConfigurationsProperties
                = new NvaInterfaceConfigurationsProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("subnet".equals(fieldName)) {
                    deserializedNvaInterfaceConfigurationsProperties.subnet
                        = NvaInVnetSubnetReferenceProperties.fromJson(reader);
                } else if ("type".equals(fieldName)) {
                    List<NvaNicType> type = reader.readArray(reader1 -> NvaNicType.fromString(reader1.getString()));
                    deserializedNvaInterfaceConfigurationsProperties.type = type;
                } else if ("name".equals(fieldName)) {
                    deserializedNvaInterfaceConfigurationsProperties.name = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNvaInterfaceConfigurationsProperties;
        });
    }
}
