// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.NspServiceTagsResourceInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of the request to list NSP service tags.
 */
@Fluent
public final class NspServiceTagsListResult implements JsonSerializable<NspServiceTagsListResult> {
    /*
     * Gets paged list of NSP service tags.
     */
    private List<NspServiceTagsResourceInner> value;

    /*
     * Gets the URL to get the next page of results.
     */
    private String nextLink;

    /**
     * Creates an instance of NspServiceTagsListResult class.
     */
    public NspServiceTagsListResult() {
    }

    /**
     * Get the value property: Gets paged list of NSP service tags.
     * 
     * @return the value value.
     */
    public List<NspServiceTagsResourceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Gets paged list of NSP service tags.
     * 
     * @param value the value value to set.
     * @return the NspServiceTagsListResult object itself.
     */
    public NspServiceTagsListResult withValue(List<NspServiceTagsResourceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Gets the URL to get the next page of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Gets the URL to get the next page of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the NspServiceTagsListResult object itself.
     */
    public NspServiceTagsListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NspServiceTagsListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NspServiceTagsListResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NspServiceTagsListResult.
     */
    public static NspServiceTagsListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NspServiceTagsListResult deserializedNspServiceTagsListResult = new NspServiceTagsListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<NspServiceTagsResourceInner> value
                        = reader.readArray(reader1 -> NspServiceTagsResourceInner.fromJson(reader1));
                    deserializedNspServiceTagsListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedNspServiceTagsListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNspServiceTagsListResult;
        });
    }
}
