// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.NspAccessRuleInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of the request to list NSP access rules. Contains a list of NSP access rules and a URL link to get the next
 * set of results.
 */
@Fluent
public final class NspAccessRuleListResult implements JsonSerializable<NspAccessRuleListResult> {
    /*
     * Gets a page of NSP access rule
     */
    private List<NspAccessRuleInner> value;

    /*
     * Gets the URL to get the next page of results.
     */
    private String nextLink;

    /**
     * Creates an instance of NspAccessRuleListResult class.
     */
    public NspAccessRuleListResult() {
    }

    /**
     * Get the value property: Gets a page of NSP access rule.
     * 
     * @return the value value.
     */
    public List<NspAccessRuleInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Gets a page of NSP access rule.
     * 
     * @param value the value value to set.
     * @return the NspAccessRuleListResult object itself.
     */
    public NspAccessRuleListResult withValue(List<NspAccessRuleInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Gets the URL to get the next page of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Gets the URL to get the next page of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the NspAccessRuleListResult object itself.
     */
    public NspAccessRuleListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NspAccessRuleListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NspAccessRuleListResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NspAccessRuleListResult.
     */
    public static NspAccessRuleListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NspAccessRuleListResult deserializedNspAccessRuleListResult = new NspAccessRuleListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<NspAccessRuleInner> value = reader.readArray(reader1 -> NspAccessRuleInner.fromJson(reader1));
                    deserializedNspAccessRuleListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedNspAccessRuleListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNspAccessRuleListResult;
        });
    }
}
