// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Indicates the scope of the load balancer: external (Public) or internal (Private).
 */
public final class LoadBalancerScope extends ExpandableStringEnum<LoadBalancerScope> {
    /**
     * Static value Public for LoadBalancerScope.
     */
    public static final LoadBalancerScope PUBLIC = fromString("Public");

    /**
     * Static value Private for LoadBalancerScope.
     */
    public static final LoadBalancerScope PRIVATE = fromString("Private");

    /**
     * Creates a new instance of LoadBalancerScope value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public LoadBalancerScope() {
    }

    /**
     * Creates or finds a LoadBalancerScope from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding LoadBalancerScope.
     */
    public static LoadBalancerScope fromString(String name) {
        return fromString(name, LoadBalancerScope.class);
    }

    /**
     * Gets known LoadBalancerScope values.
     * 
     * @return known LoadBalancerScope values.
     */
    public static Collection<LoadBalancerScope> values() {
        return values(LoadBalancerScope.class);
    }
}
