// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.VpnGatewayInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of the request to list VpnGateways. It contains a list of VpnGateways and a URL nextLink to get the next set
 * of results.
 */
@Fluent
public final class ListVpnGatewaysResult implements JsonSerializable<ListVpnGatewaysResult> {
    /*
     * List of VpnGateways.
     */
    private List<VpnGatewayInner> value;

    /*
     * URL to get the next set of operation list results if there are any.
     */
    private String nextLink;

    /**
     * Creates an instance of ListVpnGatewaysResult class.
     */
    public ListVpnGatewaysResult() {
    }

    /**
     * Get the value property: List of VpnGateways.
     * 
     * @return the value value.
     */
    public List<VpnGatewayInner> value() {
        return this.value;
    }

    /**
     * Set the value property: List of VpnGateways.
     * 
     * @param value the value value to set.
     * @return the ListVpnGatewaysResult object itself.
     */
    public ListVpnGatewaysResult withValue(List<VpnGatewayInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: URL to get the next set of operation list results if there are any.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: URL to get the next set of operation list results if there are any.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ListVpnGatewaysResult object itself.
     */
    public ListVpnGatewaysResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ListVpnGatewaysResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ListVpnGatewaysResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ListVpnGatewaysResult.
     */
    public static ListVpnGatewaysResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ListVpnGatewaysResult deserializedListVpnGatewaysResult = new ListVpnGatewaysResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<VpnGatewayInner> value = reader.readArray(reader1 -> VpnGatewayInner.fromJson(reader1));
                    deserializedListVpnGatewaysResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedListVpnGatewaysResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedListVpnGatewaysResult;
        });
    }
}
