// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Resiliency Recommendation details.
 */
@Fluent
public final class GatewayResiliencyRecommendation implements JsonSerializable<GatewayResiliencyRecommendation> {
    /*
     * Recommendation Title
     */
    private String recommendationTitle;

    /*
     * Recommendation Id
     */
    private String recommendationId;

    /*
     * Impact associated with the recommendation
     */
    private String severity;

    /*
     * Recommendation details
     */
    private String recommendationText;

    /*
     * Acton items to apply the recommendation
     */
    private String callToActionText;

    /*
     * Link to the public documentation for the associated recommendation
     */
    private String callToActionLink;

    /**
     * Creates an instance of GatewayResiliencyRecommendation class.
     */
    public GatewayResiliencyRecommendation() {
    }

    /**
     * Get the recommendationTitle property: Recommendation Title.
     * 
     * @return the recommendationTitle value.
     */
    public String recommendationTitle() {
        return this.recommendationTitle;
    }

    /**
     * Set the recommendationTitle property: Recommendation Title.
     * 
     * @param recommendationTitle the recommendationTitle value to set.
     * @return the GatewayResiliencyRecommendation object itself.
     */
    public GatewayResiliencyRecommendation withRecommendationTitle(String recommendationTitle) {
        this.recommendationTitle = recommendationTitle;
        return this;
    }

    /**
     * Get the recommendationId property: Recommendation Id.
     * 
     * @return the recommendationId value.
     */
    public String recommendationId() {
        return this.recommendationId;
    }

    /**
     * Set the recommendationId property: Recommendation Id.
     * 
     * @param recommendationId the recommendationId value to set.
     * @return the GatewayResiliencyRecommendation object itself.
     */
    public GatewayResiliencyRecommendation withRecommendationId(String recommendationId) {
        this.recommendationId = recommendationId;
        return this;
    }

    /**
     * Get the severity property: Impact associated with the recommendation.
     * 
     * @return the severity value.
     */
    public String severity() {
        return this.severity;
    }

    /**
     * Set the severity property: Impact associated with the recommendation.
     * 
     * @param severity the severity value to set.
     * @return the GatewayResiliencyRecommendation object itself.
     */
    public GatewayResiliencyRecommendation withSeverity(String severity) {
        this.severity = severity;
        return this;
    }

    /**
     * Get the recommendationText property: Recommendation details.
     * 
     * @return the recommendationText value.
     */
    public String recommendationText() {
        return this.recommendationText;
    }

    /**
     * Set the recommendationText property: Recommendation details.
     * 
     * @param recommendationText the recommendationText value to set.
     * @return the GatewayResiliencyRecommendation object itself.
     */
    public GatewayResiliencyRecommendation withRecommendationText(String recommendationText) {
        this.recommendationText = recommendationText;
        return this;
    }

    /**
     * Get the callToActionText property: Acton items to apply the recommendation.
     * 
     * @return the callToActionText value.
     */
    public String callToActionText() {
        return this.callToActionText;
    }

    /**
     * Set the callToActionText property: Acton items to apply the recommendation.
     * 
     * @param callToActionText the callToActionText value to set.
     * @return the GatewayResiliencyRecommendation object itself.
     */
    public GatewayResiliencyRecommendation withCallToActionText(String callToActionText) {
        this.callToActionText = callToActionText;
        return this;
    }

    /**
     * Get the callToActionLink property: Link to the public documentation for the associated recommendation.
     * 
     * @return the callToActionLink value.
     */
    public String callToActionLink() {
        return this.callToActionLink;
    }

    /**
     * Set the callToActionLink property: Link to the public documentation for the associated recommendation.
     * 
     * @param callToActionLink the callToActionLink value to set.
     * @return the GatewayResiliencyRecommendation object itself.
     */
    public GatewayResiliencyRecommendation withCallToActionLink(String callToActionLink) {
        this.callToActionLink = callToActionLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("recommendationTitle", this.recommendationTitle);
        jsonWriter.writeStringField("recommendationId", this.recommendationId);
        jsonWriter.writeStringField("severity", this.severity);
        jsonWriter.writeStringField("recommendationText", this.recommendationText);
        jsonWriter.writeStringField("callToActionText", this.callToActionText);
        jsonWriter.writeStringField("callToActionLink", this.callToActionLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GatewayResiliencyRecommendation from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GatewayResiliencyRecommendation if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GatewayResiliencyRecommendation.
     */
    public static GatewayResiliencyRecommendation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GatewayResiliencyRecommendation deserializedGatewayResiliencyRecommendation
                = new GatewayResiliencyRecommendation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("recommendationTitle".equals(fieldName)) {
                    deserializedGatewayResiliencyRecommendation.recommendationTitle = reader.getString();
                } else if ("recommendationId".equals(fieldName)) {
                    deserializedGatewayResiliencyRecommendation.recommendationId = reader.getString();
                } else if ("severity".equals(fieldName)) {
                    deserializedGatewayResiliencyRecommendation.severity = reader.getString();
                } else if ("recommendationText".equals(fieldName)) {
                    deserializedGatewayResiliencyRecommendation.recommendationText = reader.getString();
                } else if ("callToActionText".equals(fieldName)) {
                    deserializedGatewayResiliencyRecommendation.callToActionText = reader.getString();
                } else if ("callToActionLink".equals(fieldName)) {
                    deserializedGatewayResiliencyRecommendation.callToActionLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGatewayResiliencyRecommendation;
        });
    }
}
