// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Will contain the filter name and values to operate on.
 */
@Fluent
public final class FilterItems implements JsonSerializable<FilterItems> {
    /*
     * The name of the field we would like to filter
     */
    private String field;

    /*
     * List of values to filter the current field by
     */
    private List<String> values;

    /**
     * Creates an instance of FilterItems class.
     */
    public FilterItems() {
    }

    /**
     * Get the field property: The name of the field we would like to filter.
     * 
     * @return the field value.
     */
    public String field() {
        return this.field;
    }

    /**
     * Set the field property: The name of the field we would like to filter.
     * 
     * @param field the field value to set.
     * @return the FilterItems object itself.
     */
    public FilterItems withField(String field) {
        this.field = field;
        return this;
    }

    /**
     * Get the values property: List of values to filter the current field by.
     * 
     * @return the values value.
     */
    public List<String> values() {
        return this.values;
    }

    /**
     * Set the values property: List of values to filter the current field by.
     * 
     * @param values the values value to set.
     * @return the FilterItems object itself.
     */
    public FilterItems withValues(List<String> values) {
        this.values = values;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("field", this.field);
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FilterItems from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FilterItems if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the FilterItems.
     */
    public static FilterItems fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FilterItems deserializedFilterItems = new FilterItems();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("field".equals(fieldName)) {
                    deserializedFilterItems.field = reader.getString();
                } else if ("values".equals(fieldName)) {
                    List<String> values = reader.readArray(reader1 -> reader1.getString());
                    deserializedFilterItems.values = values;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFilterItems;
        });
    }
}
