// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The ExpressRouteFailoverRedundantRoute model.
 */
@Fluent
public final class ExpressRouteFailoverRedundantRoute implements JsonSerializable<ExpressRouteFailoverRedundantRoute> {
    /*
     * A list of all the peering locations for the redundant routes
     */
    private List<String> peeringLocations;

    /*
     * A list of all the redundant routes in the peering locations
     */
    private List<String> routes;

    /**
     * Creates an instance of ExpressRouteFailoverRedundantRoute class.
     */
    public ExpressRouteFailoverRedundantRoute() {
    }

    /**
     * Get the peeringLocations property: A list of all the peering locations for the redundant routes.
     * 
     * @return the peeringLocations value.
     */
    public List<String> peeringLocations() {
        return this.peeringLocations;
    }

    /**
     * Set the peeringLocations property: A list of all the peering locations for the redundant routes.
     * 
     * @param peeringLocations the peeringLocations value to set.
     * @return the ExpressRouteFailoverRedundantRoute object itself.
     */
    public ExpressRouteFailoverRedundantRoute withPeeringLocations(List<String> peeringLocations) {
        this.peeringLocations = peeringLocations;
        return this;
    }

    /**
     * Get the routes property: A list of all the redundant routes in the peering locations.
     * 
     * @return the routes value.
     */
    public List<String> routes() {
        return this.routes;
    }

    /**
     * Set the routes property: A list of all the redundant routes in the peering locations.
     * 
     * @param routes the routes value to set.
     * @return the ExpressRouteFailoverRedundantRoute object itself.
     */
    public ExpressRouteFailoverRedundantRoute withRoutes(List<String> routes) {
        this.routes = routes;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("peeringLocations", this.peeringLocations,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("routes", this.routes, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExpressRouteFailoverRedundantRoute from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExpressRouteFailoverRedundantRoute if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExpressRouteFailoverRedundantRoute.
     */
    public static ExpressRouteFailoverRedundantRoute fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRouteFailoverRedundantRoute deserializedExpressRouteFailoverRedundantRoute
                = new ExpressRouteFailoverRedundantRoute();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("peeringLocations".equals(fieldName)) {
                    List<String> peeringLocations = reader.readArray(reader1 -> reader1.getString());
                    deserializedExpressRouteFailoverRedundantRoute.peeringLocations = peeringLocations;
                } else if ("routes".equals(fieldName)) {
                    List<String> routes = reader.readArray(reader1 -> reader1.getString());
                    deserializedExpressRouteFailoverRedundantRoute.routes = routes;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExpressRouteFailoverRedundantRoute;
        });
    }
}
