// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitPeeringInner;
import java.io.IOException;
import java.util.List;

/**
 * Response for ListPeering API service call retrieves all peerings that belong to an ExpressRouteCircuit.
 */
@Fluent
public final class ExpressRouteCircuitPeeringListResult
    implements JsonSerializable<ExpressRouteCircuitPeeringListResult> {
    /*
     * The peerings in an express route circuit.
     */
    private List<ExpressRouteCircuitPeeringInner> value;

    /*
     * The URL to get the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of ExpressRouteCircuitPeeringListResult class.
     */
    public ExpressRouteCircuitPeeringListResult() {
    }

    /**
     * Get the value property: The peerings in an express route circuit.
     * 
     * @return the value value.
     */
    public List<ExpressRouteCircuitPeeringInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The peerings in an express route circuit.
     * 
     * @param value the value value to set.
     * @return the ExpressRouteCircuitPeeringListResult object itself.
     */
    public ExpressRouteCircuitPeeringListResult withValue(List<ExpressRouteCircuitPeeringInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ExpressRouteCircuitPeeringListResult object itself.
     */
    public ExpressRouteCircuitPeeringListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExpressRouteCircuitPeeringListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExpressRouteCircuitPeeringListResult if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExpressRouteCircuitPeeringListResult.
     */
    public static ExpressRouteCircuitPeeringListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRouteCircuitPeeringListResult deserializedExpressRouteCircuitPeeringListResult
                = new ExpressRouteCircuitPeeringListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ExpressRouteCircuitPeeringInner> value
                        = reader.readArray(reader1 -> ExpressRouteCircuitPeeringInner.fromJson(reader1));
                    deserializedExpressRouteCircuitPeeringListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedExpressRouteCircuitPeeringListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExpressRouteCircuitPeeringListResult;
        });
    }
}
