// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ARP table associated with the ExpressRouteCircuit.
 */
@Fluent
public final class ExpressRouteCircuitArpTable implements JsonSerializable<ExpressRouteCircuitArpTable> {
    /*
     * Entry age in minutes.
     */
    private Integer age;

    /*
     * Interface address.
     */
    private String interfaceProperty;

    /*
     * The IP address.
     */
    private String ipAddress;

    /*
     * The MAC address.
     */
    private String macAddress;

    /**
     * Creates an instance of ExpressRouteCircuitArpTable class.
     */
    public ExpressRouteCircuitArpTable() {
    }

    /**
     * Get the age property: Entry age in minutes.
     * 
     * @return the age value.
     */
    public Integer age() {
        return this.age;
    }

    /**
     * Set the age property: Entry age in minutes.
     * 
     * @param age the age value to set.
     * @return the ExpressRouteCircuitArpTable object itself.
     */
    public ExpressRouteCircuitArpTable withAge(Integer age) {
        this.age = age;
        return this;
    }

    /**
     * Get the interfaceProperty property: Interface address.
     * 
     * @return the interfaceProperty value.
     */
    public String interfaceProperty() {
        return this.interfaceProperty;
    }

    /**
     * Set the interfaceProperty property: Interface address.
     * 
     * @param interfaceProperty the interfaceProperty value to set.
     * @return the ExpressRouteCircuitArpTable object itself.
     */
    public ExpressRouteCircuitArpTable withInterfaceProperty(String interfaceProperty) {
        this.interfaceProperty = interfaceProperty;
        return this;
    }

    /**
     * Get the ipAddress property: The IP address.
     * 
     * @return the ipAddress value.
     */
    public String ipAddress() {
        return this.ipAddress;
    }

    /**
     * Set the ipAddress property: The IP address.
     * 
     * @param ipAddress the ipAddress value to set.
     * @return the ExpressRouteCircuitArpTable object itself.
     */
    public ExpressRouteCircuitArpTable withIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    /**
     * Get the macAddress property: The MAC address.
     * 
     * @return the macAddress value.
     */
    public String macAddress() {
        return this.macAddress;
    }

    /**
     * Set the macAddress property: The MAC address.
     * 
     * @param macAddress the macAddress value to set.
     * @return the ExpressRouteCircuitArpTable object itself.
     */
    public ExpressRouteCircuitArpTable withMacAddress(String macAddress) {
        this.macAddress = macAddress;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("age", this.age);
        jsonWriter.writeStringField("interface", this.interfaceProperty);
        jsonWriter.writeStringField("ipAddress", this.ipAddress);
        jsonWriter.writeStringField("macAddress", this.macAddress);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExpressRouteCircuitArpTable from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExpressRouteCircuitArpTable if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExpressRouteCircuitArpTable.
     */
    public static ExpressRouteCircuitArpTable fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRouteCircuitArpTable deserializedExpressRouteCircuitArpTable = new ExpressRouteCircuitArpTable();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("age".equals(fieldName)) {
                    deserializedExpressRouteCircuitArpTable.age = reader.getNullable(JsonReader::getInt);
                } else if ("interface".equals(fieldName)) {
                    deserializedExpressRouteCircuitArpTable.interfaceProperty = reader.getString();
                } else if ("ipAddress".equals(fieldName)) {
                    deserializedExpressRouteCircuitArpTable.ipAddress = reader.getString();
                } else if ("macAddress".equals(fieldName)) {
                    deserializedExpressRouteCircuitArpTable.macAddress = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExpressRouteCircuitArpTable;
        });
    }
}
