// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The request for DisassociateCloudServicePublicIpOperation.
 */
@Fluent
public final class DisassociateCloudServicePublicIpRequest
    implements JsonSerializable<DisassociateCloudServicePublicIpRequest> {
    /*
     * ARM ID of the Standalone Public IP to associate. This is of the form :
     * /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Network/publicIPAddresses/
     * {publicIpAddressName}
     */
    private String publicIpArmId;

    /**
     * Creates an instance of DisassociateCloudServicePublicIpRequest class.
     */
    public DisassociateCloudServicePublicIpRequest() {
    }

    /**
     * Get the publicIpArmId property: ARM ID of the Standalone Public IP to associate. This is of the form :
     * /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Network/publicIPAddresses/{publicIpAddressName}.
     * 
     * @return the publicIpArmId value.
     */
    public String publicIpArmId() {
        return this.publicIpArmId;
    }

    /**
     * Set the publicIpArmId property: ARM ID of the Standalone Public IP to associate. This is of the form :
     * /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Network/publicIPAddresses/{publicIpAddressName}.
     * 
     * @param publicIpArmId the publicIpArmId value to set.
     * @return the DisassociateCloudServicePublicIpRequest object itself.
     */
    public DisassociateCloudServicePublicIpRequest withPublicIpArmId(String publicIpArmId) {
        this.publicIpArmId = publicIpArmId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (publicIpArmId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property publicIpArmId in model DisassociateCloudServicePublicIpRequest"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DisassociateCloudServicePublicIpRequest.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("publicIpArmId", this.publicIpArmId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DisassociateCloudServicePublicIpRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DisassociateCloudServicePublicIpRequest if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DisassociateCloudServicePublicIpRequest.
     */
    public static DisassociateCloudServicePublicIpRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DisassociateCloudServicePublicIpRequest deserializedDisassociateCloudServicePublicIpRequest
                = new DisassociateCloudServicePublicIpRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("publicIpArmId".equals(fieldName)) {
                    deserializedDisassociateCloudServicePublicIpRequest.publicIpArmId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDisassociateCloudServicePublicIpRequest;
        });
    }
}
