// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * DhcpOptions contains an array of DNS servers available to VMs deployed in the virtual network. Standard DHCP option
 * for a subnet overrides VNET DHCP options.
 */
@Fluent
public final class DhcpOptions implements JsonSerializable<DhcpOptions> {
    /*
     * The list of DNS servers IP addresses.
     */
    private List<String> dnsServers;

    /**
     * Creates an instance of DhcpOptions class.
     */
    public DhcpOptions() {
    }

    /**
     * Get the dnsServers property: The list of DNS servers IP addresses.
     * 
     * @return the dnsServers value.
     */
    public List<String> dnsServers() {
        return this.dnsServers;
    }

    /**
     * Set the dnsServers property: The list of DNS servers IP addresses.
     * 
     * @param dnsServers the dnsServers value to set.
     * @return the DhcpOptions object itself.
     */
    public DhcpOptions withDnsServers(List<String> dnsServers) {
        this.dnsServers = dnsServers;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("dnsServers", this.dnsServers, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DhcpOptions from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DhcpOptions if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the DhcpOptions.
     */
    public static DhcpOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DhcpOptions deserializedDhcpOptions = new DhcpOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("dnsServers".equals(fieldName)) {
                    List<String> dnsServers = reader.readArray(reader1 -> reader1.getString());
                    deserializedDhcpOptions.dnsServers = dnsServers;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDhcpOptions;
        });
    }
}
