// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The traffic type (one of Tcp, Udp, TcpSyn) that the detection rule will be applied upon.
 */
public final class DdosTrafficType extends ExpandableStringEnum<DdosTrafficType> {
    /**
     * Static value Tcp for DdosTrafficType.
     */
    public static final DdosTrafficType TCP = fromString("Tcp");

    /**
     * Static value Udp for DdosTrafficType.
     */
    public static final DdosTrafficType UDP = fromString("Udp");

    /**
     * Static value TcpSyn for DdosTrafficType.
     */
    public static final DdosTrafficType TCP_SYN = fromString("TcpSyn");

    /**
     * Creates a new instance of DdosTrafficType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public DdosTrafficType() {
    }

    /**
     * Creates or finds a DdosTrafficType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding DdosTrafficType.
     */
    public static DdosTrafficType fromString(String name) {
        return fromString(name, DdosTrafficType.class);
    }

    /**
     * Gets known DdosTrafficType values.
     * 
     * @return known DdosTrafficType values.
     */
    public static Collection<DdosTrafficType> values() {
        return values(DdosTrafficType.class);
    }
}
