// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.DdosDetectionRulePropertiesFormat;
import java.io.IOException;

/**
 * A DDoS detection rule resource.
 */
@Fluent
public final class DdosDetectionRule extends SubResource {
    /*
     * The name of the DDoS detection rule.
     */
    private String name;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    private String etag;

    /*
     * The resource type.
     */
    private String type;

    /*
     * Properties of the DDoS detection rule.
     */
    private DdosDetectionRulePropertiesFormat innerProperties;

    /**
     * Creates an instance of DdosDetectionRule class.
     */
    public DdosDetectionRule() {
    }

    /**
     * Get the name property: The name of the DDoS detection rule.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the DDoS detection rule.
     * 
     * @param name the name value to set.
     * @return the DdosDetectionRule object itself.
     */
    public DdosDetectionRule withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: The resource type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the innerProperties property: Properties of the DDoS detection rule.
     * 
     * @return the innerProperties value.
     */
    private DdosDetectionRulePropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DdosDetectionRule withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the DDoS detection rule.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the detectionMode property: The detection mode for the DDoS detection rule.
     * 
     * @return the detectionMode value.
     */
    public DdosDetectionMode detectionMode() {
        return this.innerProperties() == null ? null : this.innerProperties().detectionMode();
    }

    /**
     * Set the detectionMode property: The detection mode for the DDoS detection rule.
     * 
     * @param detectionMode the detectionMode value to set.
     * @return the DdosDetectionRule object itself.
     */
    public DdosDetectionRule withDetectionMode(DdosDetectionMode detectionMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DdosDetectionRulePropertiesFormat();
        }
        this.innerProperties().withDetectionMode(detectionMode);
        return this;
    }

    /**
     * Get the trafficDetectionRule property: The traffic detection rule details.
     * 
     * @return the trafficDetectionRule value.
     */
    public TrafficDetectionRule trafficDetectionRule() {
        return this.innerProperties() == null ? null : this.innerProperties().trafficDetectionRule();
    }

    /**
     * Set the trafficDetectionRule property: The traffic detection rule details.
     * 
     * @param trafficDetectionRule the trafficDetectionRule value to set.
     * @return the DdosDetectionRule object itself.
     */
    public DdosDetectionRule withTrafficDetectionRule(TrafficDetectionRule trafficDetectionRule) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DdosDetectionRulePropertiesFormat();
        }
        this.innerProperties().withTrafficDetectionRule(trafficDetectionRule);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DdosDetectionRule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DdosDetectionRule if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the DdosDetectionRule.
     */
    public static DdosDetectionRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DdosDetectionRule deserializedDdosDetectionRule = new DdosDetectionRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedDdosDetectionRule.withId(reader.getString());
                } else if ("name".equals(fieldName)) {
                    deserializedDdosDetectionRule.name = reader.getString();
                } else if ("etag".equals(fieldName)) {
                    deserializedDdosDetectionRule.etag = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedDdosDetectionRule.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedDdosDetectionRule.innerProperties = DdosDetectionRulePropertiesFormat.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDdosDetectionRule;
        });
    }
}
