// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The detection mode for the DDoS detection rule.
 */
public final class DdosDetectionMode extends ExpandableStringEnum<DdosDetectionMode> {
    /**
     * Static value TrafficThreshold for DdosDetectionMode.
     */
    public static final DdosDetectionMode TRAFFIC_THRESHOLD = fromString("TrafficThreshold");

    /**
     * Creates a new instance of DdosDetectionMode value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public DdosDetectionMode() {
    }

    /**
     * Creates or finds a DdosDetectionMode from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding DdosDetectionMode.
     */
    public static DdosDetectionMode fromString(String name) {
        return fromString(name, DdosDetectionMode.class);
    }

    /**
     * Gets known DdosDetectionMode values.
     * 
     * @return known DdosDetectionMode values.
     */
    public static Collection<DdosDetectionMode> values() {
        return values(DdosDetectionMode.class);
    }
}
