// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Gateway connection authentication type.
 */
public final class ConnectionAuthenticationType extends ExpandableStringEnum<ConnectionAuthenticationType> {
    /**
     * Static value PSK for ConnectionAuthenticationType.
     */
    public static final ConnectionAuthenticationType PSK = fromString("PSK");

    /**
     * Static value Certificate for ConnectionAuthenticationType.
     */
    public static final ConnectionAuthenticationType CERTIFICATE = fromString("Certificate");

    /**
     * Creates a new instance of ConnectionAuthenticationType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ConnectionAuthenticationType() {
    }

    /**
     * Creates or finds a ConnectionAuthenticationType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ConnectionAuthenticationType.
     */
    public static ConnectionAuthenticationType fromString(String name) {
        return fromString(name, ConnectionAuthenticationType.class);
    }

    /**
     * Gets known ConnectionAuthenticationType values.
     * 
     * @return known ConnectionAuthenticationType values.
     */
    public static Collection<ConnectionAuthenticationType> values() {
        return values(ConnectionAuthenticationType.class);
    }
}
