// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Certificate Authentication information for a certificate based authentication connection.
 */
@Fluent
public final class CertificateAuthentication implements JsonSerializable<CertificateAuthentication> {
    /*
     * Keyvault secret ID for outbound authentication certificate.
     */
    private String outboundAuthCertificate;

    /*
     * Inbound authentication certificate subject name.
     */
    private String inboundAuthCertificateSubjectName;

    /*
     * Inbound authentication certificate public keys.
     */
    private List<String> inboundAuthCertificateChain;

    /**
     * Creates an instance of CertificateAuthentication class.
     */
    public CertificateAuthentication() {
    }

    /**
     * Get the outboundAuthCertificate property: Keyvault secret ID for outbound authentication certificate.
     * 
     * @return the outboundAuthCertificate value.
     */
    public String outboundAuthCertificate() {
        return this.outboundAuthCertificate;
    }

    /**
     * Set the outboundAuthCertificate property: Keyvault secret ID for outbound authentication certificate.
     * 
     * @param outboundAuthCertificate the outboundAuthCertificate value to set.
     * @return the CertificateAuthentication object itself.
     */
    public CertificateAuthentication withOutboundAuthCertificate(String outboundAuthCertificate) {
        this.outboundAuthCertificate = outboundAuthCertificate;
        return this;
    }

    /**
     * Get the inboundAuthCertificateSubjectName property: Inbound authentication certificate subject name.
     * 
     * @return the inboundAuthCertificateSubjectName value.
     */
    public String inboundAuthCertificateSubjectName() {
        return this.inboundAuthCertificateSubjectName;
    }

    /**
     * Set the inboundAuthCertificateSubjectName property: Inbound authentication certificate subject name.
     * 
     * @param inboundAuthCertificateSubjectName the inboundAuthCertificateSubjectName value to set.
     * @return the CertificateAuthentication object itself.
     */
    public CertificateAuthentication withInboundAuthCertificateSubjectName(String inboundAuthCertificateSubjectName) {
        this.inboundAuthCertificateSubjectName = inboundAuthCertificateSubjectName;
        return this;
    }

    /**
     * Get the inboundAuthCertificateChain property: Inbound authentication certificate public keys.
     * 
     * @return the inboundAuthCertificateChain value.
     */
    public List<String> inboundAuthCertificateChain() {
        return this.inboundAuthCertificateChain;
    }

    /**
     * Set the inboundAuthCertificateChain property: Inbound authentication certificate public keys.
     * 
     * @param inboundAuthCertificateChain the inboundAuthCertificateChain value to set.
     * @return the CertificateAuthentication object itself.
     */
    public CertificateAuthentication withInboundAuthCertificateChain(List<String> inboundAuthCertificateChain) {
        this.inboundAuthCertificateChain = inboundAuthCertificateChain;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("outboundAuthCertificate", this.outboundAuthCertificate);
        jsonWriter.writeStringField("inboundAuthCertificateSubjectName", this.inboundAuthCertificateSubjectName);
        jsonWriter.writeArrayField("inboundAuthCertificateChain", this.inboundAuthCertificateChain,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CertificateAuthentication from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CertificateAuthentication if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CertificateAuthentication.
     */
    public static CertificateAuthentication fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CertificateAuthentication deserializedCertificateAuthentication = new CertificateAuthentication();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("outboundAuthCertificate".equals(fieldName)) {
                    deserializedCertificateAuthentication.outboundAuthCertificate = reader.getString();
                } else if ("inboundAuthCertificateSubjectName".equals(fieldName)) {
                    deserializedCertificateAuthentication.inboundAuthCertificateSubjectName = reader.getString();
                } else if ("inboundAuthCertificateChain".equals(fieldName)) {
                    List<String> inboundAuthCertificateChain = reader.readArray(reader1 -> reader1.getString());
                    deserializedCertificateAuthentication.inboundAuthCertificateChain = inboundAuthCertificateChain;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCertificateAuthentication;
        });
    }
}
