// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.BgpServiceCommunityInner;
import java.io.IOException;
import java.util.List;

/**
 * Response for the ListServiceCommunity API service call.
 */
@Fluent
public final class BgpServiceCommunityListResult implements JsonSerializable<BgpServiceCommunityListResult> {
    /*
     * A list of service community resources.
     */
    private List<BgpServiceCommunityInner> value;

    /*
     * The URL to get the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of BgpServiceCommunityListResult class.
     */
    public BgpServiceCommunityListResult() {
    }

    /**
     * Get the value property: A list of service community resources.
     * 
     * @return the value value.
     */
    public List<BgpServiceCommunityInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of service community resources.
     * 
     * @param value the value value to set.
     * @return the BgpServiceCommunityListResult object itself.
     */
    public BgpServiceCommunityListResult withValue(List<BgpServiceCommunityInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the BgpServiceCommunityListResult object itself.
     */
    public BgpServiceCommunityListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BgpServiceCommunityListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BgpServiceCommunityListResult if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BgpServiceCommunityListResult.
     */
    public static BgpServiceCommunityListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BgpServiceCommunityListResult deserializedBgpServiceCommunityListResult
                = new BgpServiceCommunityListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<BgpServiceCommunityInner> value
                        = reader.readArray(reader1 -> BgpServiceCommunityInner.fromJson(reader1));
                    deserializedBgpServiceCommunityListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedBgpServiceCommunityListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBgpServiceCommunityListResult;
        });
    }
}
