// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The BastionHostPropertiesFormatNetworkAcls model.
 */
@Fluent
public final class BastionHostPropertiesFormatNetworkAcls
    implements JsonSerializable<BastionHostPropertiesFormatNetworkAcls> {
    /*
     * Sets the IP ACL rules for Developer Bastion Host.
     */
    private List<IpRule> ipRules;

    /**
     * Creates an instance of BastionHostPropertiesFormatNetworkAcls class.
     */
    public BastionHostPropertiesFormatNetworkAcls() {
    }

    /**
     * Get the ipRules property: Sets the IP ACL rules for Developer Bastion Host.
     * 
     * @return the ipRules value.
     */
    public List<IpRule> ipRules() {
        return this.ipRules;
    }

    /**
     * Set the ipRules property: Sets the IP ACL rules for Developer Bastion Host.
     * 
     * @param ipRules the ipRules value to set.
     * @return the BastionHostPropertiesFormatNetworkAcls object itself.
     */
    public BastionHostPropertiesFormatNetworkAcls withIpRules(List<IpRule> ipRules) {
        this.ipRules = ipRules;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (ipRules() != null) {
            ipRules().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("ipRules", this.ipRules, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BastionHostPropertiesFormatNetworkAcls from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BastionHostPropertiesFormatNetworkAcls if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BastionHostPropertiesFormatNetworkAcls.
     */
    public static BastionHostPropertiesFormatNetworkAcls fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BastionHostPropertiesFormatNetworkAcls deserializedBastionHostPropertiesFormatNetworkAcls
                = new BastionHostPropertiesFormatNetworkAcls();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("ipRules".equals(fieldName)) {
                    List<IpRule> ipRules = reader.readArray(reader1 -> IpRule.fromJson(reader1));
                    deserializedBastionHostPropertiesFormatNetworkAcls.ipRules = ipRules;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBastionHostPropertiesFormatNetworkAcls;
        });
    }
}
