// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.AutoApprovedPrivateLinkServiceInner;
import java.io.IOException;
import java.util.List;

/**
 * An array of private link service id that can be linked to a private end point with auto approved.
 */
@Fluent
public final class AutoApprovedPrivateLinkServicesResult
    implements JsonSerializable<AutoApprovedPrivateLinkServicesResult> {
    /*
     * An array of auto approved private link service.
     */
    private List<AutoApprovedPrivateLinkServiceInner> value;

    /*
     * The URL to get the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of AutoApprovedPrivateLinkServicesResult class.
     */
    public AutoApprovedPrivateLinkServicesResult() {
    }

    /**
     * Get the value property: An array of auto approved private link service.
     * 
     * @return the value value.
     */
    public List<AutoApprovedPrivateLinkServiceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: An array of auto approved private link service.
     * 
     * @param value the value value to set.
     * @return the AutoApprovedPrivateLinkServicesResult object itself.
     */
    public AutoApprovedPrivateLinkServicesResult withValue(List<AutoApprovedPrivateLinkServiceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AutoApprovedPrivateLinkServicesResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AutoApprovedPrivateLinkServicesResult if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AutoApprovedPrivateLinkServicesResult.
     */
    public static AutoApprovedPrivateLinkServicesResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AutoApprovedPrivateLinkServicesResult deserializedAutoApprovedPrivateLinkServicesResult
                = new AutoApprovedPrivateLinkServicesResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<AutoApprovedPrivateLinkServiceInner> value
                        = reader.readArray(reader1 -> AutoApprovedPrivateLinkServiceInner.fromJson(reader1));
                    deserializedAutoApprovedPrivateLinkServicesResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedAutoApprovedPrivateLinkServicesResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAutoApprovedPrivateLinkServicesResult;
        });
    }
}
