// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Details of on demand test probe request.
 */
@Fluent
public final class ApplicationGatewayOnDemandProbe implements JsonSerializable<ApplicationGatewayOnDemandProbe> {
    /*
     * The protocol used for the probe.
     */
    private ApplicationGatewayProtocol protocol;

    /*
     * Host name to send the probe to.
     */
    private String host;

    /*
     * Relative path of probe. Valid path starts from '/'. Probe is sent to <Protocol>://<host>:<port><path>.
     */
    private String path;

    /*
     * The probe timeout in seconds. Probe marked as failed if valid response is not received with this timeout period.
     * Acceptable values are from 1 second to 86400 seconds.
     */
    private Integer timeout;

    /*
     * Whether the host header should be picked from the backend http settings. Default value is false.
     */
    private Boolean pickHostnameFromBackendHttpSettings;

    /*
     * Whether to send Proxy Protocol header along with the Health Probe over TCP or TLS protocol. Default value is
     * false.
     */
    private Boolean enableProbeProxyProtocolHeader;

    /*
     * Criterion for classifying a healthy probe response.
     */
    private ApplicationGatewayProbeHealthResponseMatch match;

    /*
     * Reference to backend pool of application gateway to which probe request will be sent.
     */
    private SubResource backendAddressPool;

    /*
     * Reference to backend http setting of application gateway to be used for test probe.
     */
    private SubResource backendHttpSettings;

    /**
     * Creates an instance of ApplicationGatewayOnDemandProbe class.
     */
    public ApplicationGatewayOnDemandProbe() {
    }

    /**
     * Get the protocol property: The protocol used for the probe.
     * 
     * @return the protocol value.
     */
    public ApplicationGatewayProtocol protocol() {
        return this.protocol;
    }

    /**
     * Set the protocol property: The protocol used for the probe.
     * 
     * @param protocol the protocol value to set.
     * @return the ApplicationGatewayOnDemandProbe object itself.
     */
    public ApplicationGatewayOnDemandProbe withProtocol(ApplicationGatewayProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    /**
     * Get the host property: Host name to send the probe to.
     * 
     * @return the host value.
     */
    public String host() {
        return this.host;
    }

    /**
     * Set the host property: Host name to send the probe to.
     * 
     * @param host the host value to set.
     * @return the ApplicationGatewayOnDemandProbe object itself.
     */
    public ApplicationGatewayOnDemandProbe withHost(String host) {
        this.host = host;
        return this;
    }

    /**
     * Get the path property: Relative path of probe. Valid path starts from '/'. Probe is sent to
     * &lt;Protocol&gt;://&lt;host&gt;:&lt;port&gt;&lt;path&gt;.
     * 
     * @return the path value.
     */
    public String path() {
        return this.path;
    }

    /**
     * Set the path property: Relative path of probe. Valid path starts from '/'. Probe is sent to
     * &lt;Protocol&gt;://&lt;host&gt;:&lt;port&gt;&lt;path&gt;.
     * 
     * @param path the path value to set.
     * @return the ApplicationGatewayOnDemandProbe object itself.
     */
    public ApplicationGatewayOnDemandProbe withPath(String path) {
        this.path = path;
        return this;
    }

    /**
     * Get the timeout property: The probe timeout in seconds. Probe marked as failed if valid response is not received
     * with this timeout period. Acceptable values are from 1 second to 86400 seconds.
     * 
     * @return the timeout value.
     */
    public Integer timeout() {
        return this.timeout;
    }

    /**
     * Set the timeout property: The probe timeout in seconds. Probe marked as failed if valid response is not received
     * with this timeout period. Acceptable values are from 1 second to 86400 seconds.
     * 
     * @param timeout the timeout value to set.
     * @return the ApplicationGatewayOnDemandProbe object itself.
     */
    public ApplicationGatewayOnDemandProbe withTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    /**
     * Get the pickHostnameFromBackendHttpSettings property: Whether the host header should be picked from the backend
     * http settings. Default value is false.
     * 
     * @return the pickHostnameFromBackendHttpSettings value.
     */
    public Boolean pickHostnameFromBackendHttpSettings() {
        return this.pickHostnameFromBackendHttpSettings;
    }

    /**
     * Set the pickHostnameFromBackendHttpSettings property: Whether the host header should be picked from the backend
     * http settings. Default value is false.
     * 
     * @param pickHostnameFromBackendHttpSettings the pickHostnameFromBackendHttpSettings value to set.
     * @return the ApplicationGatewayOnDemandProbe object itself.
     */
    public ApplicationGatewayOnDemandProbe
        withPickHostnameFromBackendHttpSettings(Boolean pickHostnameFromBackendHttpSettings) {
        this.pickHostnameFromBackendHttpSettings = pickHostnameFromBackendHttpSettings;
        return this;
    }

    /**
     * Get the enableProbeProxyProtocolHeader property: Whether to send Proxy Protocol header along with the Health
     * Probe over TCP or TLS protocol. Default value is false.
     * 
     * @return the enableProbeProxyProtocolHeader value.
     */
    public Boolean enableProbeProxyProtocolHeader() {
        return this.enableProbeProxyProtocolHeader;
    }

    /**
     * Set the enableProbeProxyProtocolHeader property: Whether to send Proxy Protocol header along with the Health
     * Probe over TCP or TLS protocol. Default value is false.
     * 
     * @param enableProbeProxyProtocolHeader the enableProbeProxyProtocolHeader value to set.
     * @return the ApplicationGatewayOnDemandProbe object itself.
     */
    public ApplicationGatewayOnDemandProbe withEnableProbeProxyProtocolHeader(Boolean enableProbeProxyProtocolHeader) {
        this.enableProbeProxyProtocolHeader = enableProbeProxyProtocolHeader;
        return this;
    }

    /**
     * Get the match property: Criterion for classifying a healthy probe response.
     * 
     * @return the match value.
     */
    public ApplicationGatewayProbeHealthResponseMatch match() {
        return this.match;
    }

    /**
     * Set the match property: Criterion for classifying a healthy probe response.
     * 
     * @param match the match value to set.
     * @return the ApplicationGatewayOnDemandProbe object itself.
     */
    public ApplicationGatewayOnDemandProbe withMatch(ApplicationGatewayProbeHealthResponseMatch match) {
        this.match = match;
        return this;
    }

    /**
     * Get the backendAddressPool property: Reference to backend pool of application gateway to which probe request will
     * be sent.
     * 
     * @return the backendAddressPool value.
     */
    public SubResource backendAddressPool() {
        return this.backendAddressPool;
    }

    /**
     * Set the backendAddressPool property: Reference to backend pool of application gateway to which probe request will
     * be sent.
     * 
     * @param backendAddressPool the backendAddressPool value to set.
     * @return the ApplicationGatewayOnDemandProbe object itself.
     */
    public ApplicationGatewayOnDemandProbe withBackendAddressPool(SubResource backendAddressPool) {
        this.backendAddressPool = backendAddressPool;
        return this;
    }

    /**
     * Get the backendHttpSettings property: Reference to backend http setting of application gateway to be used for
     * test probe.
     * 
     * @return the backendHttpSettings value.
     */
    public SubResource backendHttpSettings() {
        return this.backendHttpSettings;
    }

    /**
     * Set the backendHttpSettings property: Reference to backend http setting of application gateway to be used for
     * test probe.
     * 
     * @param backendHttpSettings the backendHttpSettings value to set.
     * @return the ApplicationGatewayOnDemandProbe object itself.
     */
    public ApplicationGatewayOnDemandProbe withBackendHttpSettings(SubResource backendHttpSettings) {
        this.backendHttpSettings = backendHttpSettings;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (match() != null) {
            match().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeStringField("host", this.host);
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeNumberField("timeout", this.timeout);
        jsonWriter.writeBooleanField("pickHostNameFromBackendHttpSettings", this.pickHostnameFromBackendHttpSettings);
        jsonWriter.writeBooleanField("enableProbeProxyProtocolHeader", this.enableProbeProxyProtocolHeader);
        jsonWriter.writeJsonField("match", this.match);
        jsonWriter.writeJsonField("backendAddressPool", this.backendAddressPool);
        jsonWriter.writeJsonField("backendHttpSettings", this.backendHttpSettings);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayOnDemandProbe from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayOnDemandProbe if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationGatewayOnDemandProbe.
     */
    public static ApplicationGatewayOnDemandProbe fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayOnDemandProbe deserializedApplicationGatewayOnDemandProbe
                = new ApplicationGatewayOnDemandProbe();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("protocol".equals(fieldName)) {
                    deserializedApplicationGatewayOnDemandProbe.protocol
                        = ApplicationGatewayProtocol.fromString(reader.getString());
                } else if ("host".equals(fieldName)) {
                    deserializedApplicationGatewayOnDemandProbe.host = reader.getString();
                } else if ("path".equals(fieldName)) {
                    deserializedApplicationGatewayOnDemandProbe.path = reader.getString();
                } else if ("timeout".equals(fieldName)) {
                    deserializedApplicationGatewayOnDemandProbe.timeout = reader.getNullable(JsonReader::getInt);
                } else if ("pickHostNameFromBackendHttpSettings".equals(fieldName)) {
                    deserializedApplicationGatewayOnDemandProbe.pickHostnameFromBackendHttpSettings
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("enableProbeProxyProtocolHeader".equals(fieldName)) {
                    deserializedApplicationGatewayOnDemandProbe.enableProbeProxyProtocolHeader
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("match".equals(fieldName)) {
                    deserializedApplicationGatewayOnDemandProbe.match
                        = ApplicationGatewayProbeHealthResponseMatch.fromJson(reader);
                } else if ("backendAddressPool".equals(fieldName)) {
                    deserializedApplicationGatewayOnDemandProbe.backendAddressPool = SubResource.fromJson(reader);
                } else if ("backendHttpSettings".equals(fieldName)) {
                    deserializedApplicationGatewayOnDemandProbe.backendHttpSettings = SubResource.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayOnDemandProbe;
        });
    }
}
