// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayEntraJwtValidationConfigPropertiesFormat;
import java.io.IOException;
import java.util.List;

/**
 * Entra JWT Validation Configuration of an application gateway.
 */
@Fluent
public final class ApplicationGatewayEntraJwtValidationConfig extends SubResource {
    /*
     * Properties of the application gateway entra jwt validation configuration.
     */
    private ApplicationGatewayEntraJwtValidationConfigPropertiesFormat innerProperties;

    /*
     * Name of the entra jwt validation configuration that is unique within an application gateway.
     */
    private String name;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    private String etag;

    /**
     * Creates an instance of ApplicationGatewayEntraJwtValidationConfig class.
     */
    public ApplicationGatewayEntraJwtValidationConfig() {
    }

    /**
     * Get the innerProperties property: Properties of the application gateway entra jwt validation configuration.
     * 
     * @return the innerProperties value.
     */
    private ApplicationGatewayEntraJwtValidationConfigPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the name property: Name of the entra jwt validation configuration that is unique within an application
     * gateway.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the entra jwt validation configuration that is unique within an application
     * gateway.
     * 
     * @param name the name value to set.
     * @return the ApplicationGatewayEntraJwtValidationConfig object itself.
     */
    public ApplicationGatewayEntraJwtValidationConfig withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApplicationGatewayEntraJwtValidationConfig withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the unAuthorizedRequestAction property: Unauthorized request action.
     * 
     * @return the unAuthorizedRequestAction value.
     */
    public ApplicationGatewayUnAuthorizedRequestAction unAuthorizedRequestAction() {
        return this.innerProperties() == null ? null : this.innerProperties().unAuthorizedRequestAction();
    }

    /**
     * Set the unAuthorizedRequestAction property: Unauthorized request action.
     * 
     * @param unAuthorizedRequestAction the unAuthorizedRequestAction value to set.
     * @return the ApplicationGatewayEntraJwtValidationConfig object itself.
     */
    public ApplicationGatewayEntraJwtValidationConfig
        withUnAuthorizedRequestAction(ApplicationGatewayUnAuthorizedRequestAction unAuthorizedRequestAction) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayEntraJwtValidationConfigPropertiesFormat();
        }
        this.innerProperties().withUnAuthorizedRequestAction(unAuthorizedRequestAction);
        return this;
    }

    /**
     * Get the tenantId property: The Tenant ID of the Microsoft Entra ID application.
     * 
     * @return the tenantId value.
     */
    public String tenantId() {
        return this.innerProperties() == null ? null : this.innerProperties().tenantId();
    }

    /**
     * Set the tenantId property: The Tenant ID of the Microsoft Entra ID application.
     * 
     * @param tenantId the tenantId value to set.
     * @return the ApplicationGatewayEntraJwtValidationConfig object itself.
     */
    public ApplicationGatewayEntraJwtValidationConfig withTenantId(String tenantId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayEntraJwtValidationConfigPropertiesFormat();
        }
        this.innerProperties().withTenantId(tenantId);
        return this;
    }

    /**
     * Get the clientId property: The Client ID of the Microsoft Entra ID application.
     * 
     * @return the clientId value.
     */
    public String clientId() {
        return this.innerProperties() == null ? null : this.innerProperties().clientId();
    }

    /**
     * Set the clientId property: The Client ID of the Microsoft Entra ID application.
     * 
     * @param clientId the clientId value to set.
     * @return the ApplicationGatewayEntraJwtValidationConfig object itself.
     */
    public ApplicationGatewayEntraJwtValidationConfig withClientId(String clientId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayEntraJwtValidationConfigPropertiesFormat();
        }
        this.innerProperties().withClientId(clientId);
        return this;
    }

    /**
     * Get the audiences property: List of acceptable audience claims that can be present in the token (aud claim). A
     * maximum of 5 audiences are permitted.
     * 
     * @return the audiences value.
     */
    public List<String> audiences() {
        return this.innerProperties() == null ? null : this.innerProperties().audiences();
    }

    /**
     * Set the audiences property: List of acceptable audience claims that can be present in the token (aud claim). A
     * maximum of 5 audiences are permitted.
     * 
     * @param audiences the audiences value to set.
     * @return the ApplicationGatewayEntraJwtValidationConfig object itself.
     */
    public ApplicationGatewayEntraJwtValidationConfig withAudiences(List<String> audiences) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayEntraJwtValidationConfigPropertiesFormat();
        }
        this.innerProperties().withAudiences(audiences);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the entra jwt validation configuration resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayEntraJwtValidationConfig from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayEntraJwtValidationConfig if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationGatewayEntraJwtValidationConfig.
     */
    public static ApplicationGatewayEntraJwtValidationConfig fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayEntraJwtValidationConfig deserializedApplicationGatewayEntraJwtValidationConfig
                = new ApplicationGatewayEntraJwtValidationConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedApplicationGatewayEntraJwtValidationConfig.withId(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedApplicationGatewayEntraJwtValidationConfig.innerProperties
                        = ApplicationGatewayEntraJwtValidationConfigPropertiesFormat.fromJson(reader);
                } else if ("name".equals(fieldName)) {
                    deserializedApplicationGatewayEntraJwtValidationConfig.name = reader.getString();
                } else if ("etag".equals(fieldName)) {
                    deserializedApplicationGatewayEntraJwtValidationConfig.etag = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayEntraJwtValidationConfig;
        });
    }
}
