// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Application gateway client authentication configuration.
 */
@Fluent
public final class ApplicationGatewayClientAuthConfiguration
    implements JsonSerializable<ApplicationGatewayClientAuthConfiguration> {
    /*
     * Verify client certificate issuer name on the application gateway.
     */
    private Boolean verifyClientCertIssuerDN;

    /*
     * Verify client certificate revocation status.
     */
    private ApplicationGatewayClientRevocationOptions verifyClientRevocation;

    /*
     * Verify client Authentication mode.
     */
    private ApplicationGatewayClientAuthVerificationModes verifyClientAuthMode;

    /**
     * Creates an instance of ApplicationGatewayClientAuthConfiguration class.
     */
    public ApplicationGatewayClientAuthConfiguration() {
    }

    /**
     * Get the verifyClientCertIssuerDN property: Verify client certificate issuer name on the application gateway.
     * 
     * @return the verifyClientCertIssuerDN value.
     */
    public Boolean verifyClientCertIssuerDN() {
        return this.verifyClientCertIssuerDN;
    }

    /**
     * Set the verifyClientCertIssuerDN property: Verify client certificate issuer name on the application gateway.
     * 
     * @param verifyClientCertIssuerDN the verifyClientCertIssuerDN value to set.
     * @return the ApplicationGatewayClientAuthConfiguration object itself.
     */
    public ApplicationGatewayClientAuthConfiguration withVerifyClientCertIssuerDN(Boolean verifyClientCertIssuerDN) {
        this.verifyClientCertIssuerDN = verifyClientCertIssuerDN;
        return this;
    }

    /**
     * Get the verifyClientRevocation property: Verify client certificate revocation status.
     * 
     * @return the verifyClientRevocation value.
     */
    public ApplicationGatewayClientRevocationOptions verifyClientRevocation() {
        return this.verifyClientRevocation;
    }

    /**
     * Set the verifyClientRevocation property: Verify client certificate revocation status.
     * 
     * @param verifyClientRevocation the verifyClientRevocation value to set.
     * @return the ApplicationGatewayClientAuthConfiguration object itself.
     */
    public ApplicationGatewayClientAuthConfiguration
        withVerifyClientRevocation(ApplicationGatewayClientRevocationOptions verifyClientRevocation) {
        this.verifyClientRevocation = verifyClientRevocation;
        return this;
    }

    /**
     * Get the verifyClientAuthMode property: Verify client Authentication mode.
     * 
     * @return the verifyClientAuthMode value.
     */
    public ApplicationGatewayClientAuthVerificationModes verifyClientAuthMode() {
        return this.verifyClientAuthMode;
    }

    /**
     * Set the verifyClientAuthMode property: Verify client Authentication mode.
     * 
     * @param verifyClientAuthMode the verifyClientAuthMode value to set.
     * @return the ApplicationGatewayClientAuthConfiguration object itself.
     */
    public ApplicationGatewayClientAuthConfiguration
        withVerifyClientAuthMode(ApplicationGatewayClientAuthVerificationModes verifyClientAuthMode) {
        this.verifyClientAuthMode = verifyClientAuthMode;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("verifyClientCertIssuerDN", this.verifyClientCertIssuerDN);
        jsonWriter.writeStringField("verifyClientRevocation",
            this.verifyClientRevocation == null ? null : this.verifyClientRevocation.toString());
        jsonWriter.writeStringField("verifyClientAuthMode",
            this.verifyClientAuthMode == null ? null : this.verifyClientAuthMode.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayClientAuthConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayClientAuthConfiguration if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationGatewayClientAuthConfiguration.
     */
    public static ApplicationGatewayClientAuthConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayClientAuthConfiguration deserializedApplicationGatewayClientAuthConfiguration
                = new ApplicationGatewayClientAuthConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("verifyClientCertIssuerDN".equals(fieldName)) {
                    deserializedApplicationGatewayClientAuthConfiguration.verifyClientCertIssuerDN
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("verifyClientRevocation".equals(fieldName)) {
                    deserializedApplicationGatewayClientAuthConfiguration.verifyClientRevocation
                        = ApplicationGatewayClientRevocationOptions.fromString(reader.getString());
                } else if ("verifyClientAuthMode".equals(fieldName)) {
                    deserializedApplicationGatewayClientAuthConfiguration.verifyClientAuthMode
                        = ApplicationGatewayClientAuthVerificationModes.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayClientAuthConfiguration;
        });
    }
}
