// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.network.fluent.ReachabilityAnalysisIntentsClient;
import com.azure.resourcemanager.network.fluent.models.ReachabilityAnalysisIntentInner;
import com.azure.resourcemanager.network.models.ReachabilityAnalysisIntentListResult;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in ReachabilityAnalysisIntentsClient.
 */
public final class ReachabilityAnalysisIntentsClientImpl implements ReachabilityAnalysisIntentsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final ReachabilityAnalysisIntentsService service;

    /**
     * The service client containing this operation class.
     */
    private final NetworkManagementClientImpl client;

    /**
     * Initializes an instance of ReachabilityAnalysisIntentsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    ReachabilityAnalysisIntentsClientImpl(NetworkManagementClientImpl client) {
        this.service = RestProxy.create(ReachabilityAnalysisIntentsService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for NetworkManagementClientReachabilityAnalysisIntents to be used by the
     * proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "NetworkManagementClientReachabilityAnalysisIntents")
    public interface ReachabilityAnalysisIntentsService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/verifierWorkspaces/{workspaceName}/reachabilityAnalysisIntents")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ReachabilityAnalysisIntentListResult>> list(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("networkManagerName") String networkManagerName,
            @PathParam("workspaceName") String workspaceName, @QueryParam("skipToken") String skipToken,
            @QueryParam("skip") Integer skip, @QueryParam("top") Integer top, @QueryParam("sortKey") String sortKey,
            @QueryParam("sortValue") String sortValue, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/verifierWorkspaces/{workspaceName}/reachabilityAnalysisIntents/{reachabilityAnalysisIntentName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ReachabilityAnalysisIntentInner>> get(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("networkManagerName") String networkManagerName,
            @PathParam("workspaceName") String workspaceName,
            @PathParam("reachabilityAnalysisIntentName") String reachabilityAnalysisIntentName,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/verifierWorkspaces/{workspaceName}/reachabilityAnalysisIntents/{reachabilityAnalysisIntentName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ReachabilityAnalysisIntentInner>> create(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("networkManagerName") String networkManagerName,
            @PathParam("workspaceName") String workspaceName,
            @PathParam("reachabilityAnalysisIntentName") String reachabilityAnalysisIntentName,
            @BodyParam("application/json") ReachabilityAnalysisIntentInner body, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/verifierWorkspaces/{workspaceName}/reachabilityAnalysisIntents/{reachabilityAnalysisIntentName}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> delete(@HostParam("$host") String endpoint, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("networkManagerName") String networkManagerName,
            @PathParam("workspaceName") String workspaceName,
            @PathParam("reachabilityAnalysisIntentName") String reachabilityAnalysisIntentName,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ReachabilityAnalysisIntentListResult>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Gets list of Reachability Analysis Intents .
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @param skipToken Optional skip token.
     * @param skip Optional num entries to skip.
     * @param top Optional num entries to show.
     * @param sortKey Optional key by which to sort.
     * @param sortValue Optional sort value for pagination.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Reachability Analysis Intents along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ReachabilityAnalysisIntentInner>> listSinglePageAsync(String resourceGroupName,
        String networkManagerName, String workspaceName, String skipToken, Integer skip, Integer top, String sortKey,
        String sortValue) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        final String apiVersion = "2025-03-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(),
                resourceGroupName, networkManagerName, workspaceName, skipToken, skip, top, sortKey, sortValue, accept,
                context))
            .<PagedResponse<ReachabilityAnalysisIntentInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets list of Reachability Analysis Intents .
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @param skipToken Optional skip token.
     * @param skip Optional num entries to skip.
     * @param top Optional num entries to show.
     * @param sortKey Optional key by which to sort.
     * @param sortValue Optional sort value for pagination.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Reachability Analysis Intents along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ReachabilityAnalysisIntentInner>> listSinglePageAsync(String resourceGroupName,
        String networkManagerName, String workspaceName, String skipToken, Integer skip, Integer top, String sortKey,
        String sortValue, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        final String apiVersion = "2025-03-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), resourceGroupName,
                networkManagerName, workspaceName, skipToken, skip, top, sortKey, sortValue, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Gets list of Reachability Analysis Intents .
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @param skipToken Optional skip token.
     * @param skip Optional num entries to skip.
     * @param top Optional num entries to show.
     * @param sortKey Optional key by which to sort.
     * @param sortValue Optional sort value for pagination.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Reachability Analysis Intents as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ReachabilityAnalysisIntentInner> listAsync(String resourceGroupName, String networkManagerName,
        String workspaceName, String skipToken, Integer skip, Integer top, String sortKey, String sortValue) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, networkManagerName, workspaceName,
            skipToken, skip, top, sortKey, sortValue), nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Gets list of Reachability Analysis Intents .
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Reachability Analysis Intents as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ReachabilityAnalysisIntentInner> listAsync(String resourceGroupName, String networkManagerName,
        String workspaceName) {
        final String skipToken = null;
        final Integer skip = null;
        final Integer top = null;
        final String sortKey = null;
        final String sortValue = null;
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, networkManagerName, workspaceName,
            skipToken, skip, top, sortKey, sortValue), nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Gets list of Reachability Analysis Intents .
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @param skipToken Optional skip token.
     * @param skip Optional num entries to skip.
     * @param top Optional num entries to show.
     * @param sortKey Optional key by which to sort.
     * @param sortValue Optional sort value for pagination.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Reachability Analysis Intents as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ReachabilityAnalysisIntentInner> listAsync(String resourceGroupName, String networkManagerName,
        String workspaceName, String skipToken, Integer skip, Integer top, String sortKey, String sortValue,
        Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, networkManagerName, workspaceName,
            skipToken, skip, top, sortKey, sortValue, context), nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets list of Reachability Analysis Intents .
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Reachability Analysis Intents as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ReachabilityAnalysisIntentInner> list(String resourceGroupName, String networkManagerName,
        String workspaceName) {
        final String skipToken = null;
        final Integer skip = null;
        final Integer top = null;
        final String sortKey = null;
        final String sortValue = null;
        return new PagedIterable<>(
            listAsync(resourceGroupName, networkManagerName, workspaceName, skipToken, skip, top, sortKey, sortValue));
    }

    /**
     * Gets list of Reachability Analysis Intents .
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @param skipToken Optional skip token.
     * @param skip Optional num entries to skip.
     * @param top Optional num entries to show.
     * @param sortKey Optional key by which to sort.
     * @param sortValue Optional sort value for pagination.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Reachability Analysis Intents as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ReachabilityAnalysisIntentInner> list(String resourceGroupName, String networkManagerName,
        String workspaceName, String skipToken, Integer skip, Integer top, String sortKey, String sortValue,
        Context context) {
        return new PagedIterable<>(listAsync(resourceGroupName, networkManagerName, workspaceName, skipToken, skip, top,
            sortKey, sortValue, context));
    }

    /**
     * Get the Reachability Analysis Intent.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @param reachabilityAnalysisIntentName Reachability Analysis Intent name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Reachability Analysis Intent along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ReachabilityAnalysisIntentInner>> getWithResponseAsync(String resourceGroupName,
        String networkManagerName, String workspaceName, String reachabilityAnalysisIntentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (reachabilityAnalysisIntentName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter reachabilityAnalysisIntentName is required and cannot be null."));
        }
        final String apiVersion = "2025-03-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(),
                resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisIntentName, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the Reachability Analysis Intent.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @param reachabilityAnalysisIntentName Reachability Analysis Intent name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Reachability Analysis Intent along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ReachabilityAnalysisIntentInner>> getWithResponseAsync(String resourceGroupName,
        String networkManagerName, String workspaceName, String reachabilityAnalysisIntentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (reachabilityAnalysisIntentName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter reachabilityAnalysisIntentName is required and cannot be null."));
        }
        final String apiVersion = "2025-03-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), resourceGroupName,
            networkManagerName, workspaceName, reachabilityAnalysisIntentName, accept, context);
    }

    /**
     * Get the Reachability Analysis Intent.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @param reachabilityAnalysisIntentName Reachability Analysis Intent name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Reachability Analysis Intent on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ReachabilityAnalysisIntentInner> getAsync(String resourceGroupName, String networkManagerName,
        String workspaceName, String reachabilityAnalysisIntentName) {
        return getWithResponseAsync(resourceGroupName, networkManagerName, workspaceName,
            reachabilityAnalysisIntentName).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get the Reachability Analysis Intent.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @param reachabilityAnalysisIntentName Reachability Analysis Intent name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Reachability Analysis Intent along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ReachabilityAnalysisIntentInner> getWithResponse(String resourceGroupName,
        String networkManagerName, String workspaceName, String reachabilityAnalysisIntentName, Context context) {
        return getWithResponseAsync(resourceGroupName, networkManagerName, workspaceName,
            reachabilityAnalysisIntentName, context).block();
    }

    /**
     * Get the Reachability Analysis Intent.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @param reachabilityAnalysisIntentName Reachability Analysis Intent name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Reachability Analysis Intent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ReachabilityAnalysisIntentInner get(String resourceGroupName, String networkManagerName,
        String workspaceName, String reachabilityAnalysisIntentName) {
        return getWithResponse(resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisIntentName,
            Context.NONE).getValue();
    }

    /**
     * Creates Reachability Analysis Intent.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @param reachabilityAnalysisIntentName Reachability Analysis Intent name.
     * @param body Reachability Analysis Intent object to create/update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration information or intent on which to do the analysis on along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ReachabilityAnalysisIntentInner>> createWithResponseAsync(String resourceGroupName,
        String networkManagerName, String workspaceName, String reachabilityAnalysisIntentName,
        ReachabilityAnalysisIntentInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (reachabilityAnalysisIntentName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter reachabilityAnalysisIntentName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String apiVersion = "2025-03-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.create(this.client.getEndpoint(), apiVersion,
                this.client.getSubscriptionId(), resourceGroupName, networkManagerName, workspaceName,
                reachabilityAnalysisIntentName, body, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates Reachability Analysis Intent.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @param reachabilityAnalysisIntentName Reachability Analysis Intent name.
     * @param body Reachability Analysis Intent object to create/update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration information or intent on which to do the analysis on along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ReachabilityAnalysisIntentInner>> createWithResponseAsync(String resourceGroupName,
        String networkManagerName, String workspaceName, String reachabilityAnalysisIntentName,
        ReachabilityAnalysisIntentInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (reachabilityAnalysisIntentName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter reachabilityAnalysisIntentName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String apiVersion = "2025-03-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.create(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), resourceGroupName,
            networkManagerName, workspaceName, reachabilityAnalysisIntentName, body, accept, context);
    }

    /**
     * Creates Reachability Analysis Intent.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @param reachabilityAnalysisIntentName Reachability Analysis Intent name.
     * @param body Reachability Analysis Intent object to create/update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration information or intent on which to do the analysis on on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ReachabilityAnalysisIntentInner> createAsync(String resourceGroupName, String networkManagerName,
        String workspaceName, String reachabilityAnalysisIntentName, ReachabilityAnalysisIntentInner body) {
        return createWithResponseAsync(resourceGroupName, networkManagerName, workspaceName,
            reachabilityAnalysisIntentName, body).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates Reachability Analysis Intent.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @param reachabilityAnalysisIntentName Reachability Analysis Intent name.
     * @param body Reachability Analysis Intent object to create/update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration information or intent on which to do the analysis on along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ReachabilityAnalysisIntentInner> createWithResponse(String resourceGroupName,
        String networkManagerName, String workspaceName, String reachabilityAnalysisIntentName,
        ReachabilityAnalysisIntentInner body, Context context) {
        return createWithResponseAsync(resourceGroupName, networkManagerName, workspaceName,
            reachabilityAnalysisIntentName, body, context).block();
    }

    /**
     * Creates Reachability Analysis Intent.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @param reachabilityAnalysisIntentName Reachability Analysis Intent name.
     * @param body Reachability Analysis Intent object to create/update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration information or intent on which to do the analysis on.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ReachabilityAnalysisIntentInner create(String resourceGroupName, String networkManagerName,
        String workspaceName, String reachabilityAnalysisIntentName, ReachabilityAnalysisIntentInner body) {
        return createWithResponse(resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisIntentName,
            body, Context.NONE).getValue();
    }

    /**
     * Deletes Reachability Analysis Intent.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @param reachabilityAnalysisIntentName Reachability Analysis Intent name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String networkManagerName,
        String workspaceName, String reachabilityAnalysisIntentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (reachabilityAnalysisIntentName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter reachabilityAnalysisIntentName is required and cannot be null."));
        }
        final String apiVersion = "2025-03-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), apiVersion,
                this.client.getSubscriptionId(), resourceGroupName, networkManagerName, workspaceName,
                reachabilityAnalysisIntentName, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes Reachability Analysis Intent.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @param reachabilityAnalysisIntentName Reachability Analysis Intent name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String networkManagerName,
        String workspaceName, String reachabilityAnalysisIntentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (reachabilityAnalysisIntentName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter reachabilityAnalysisIntentName is required and cannot be null."));
        }
        final String apiVersion = "2025-03-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), resourceGroupName,
            networkManagerName, workspaceName, reachabilityAnalysisIntentName, accept, context);
    }

    /**
     * Deletes Reachability Analysis Intent.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @param reachabilityAnalysisIntentName Reachability Analysis Intent name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String networkManagerName, String workspaceName,
        String reachabilityAnalysisIntentName) {
        return deleteWithResponseAsync(resourceGroupName, networkManagerName, workspaceName,
            reachabilityAnalysisIntentName).flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes Reachability Analysis Intent.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @param reachabilityAnalysisIntentName Reachability Analysis Intent name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String networkManagerName, String workspaceName,
        String reachabilityAnalysisIntentName, Context context) {
        return deleteWithResponseAsync(resourceGroupName, networkManagerName, workspaceName,
            reachabilityAnalysisIntentName, context).block();
    }

    /**
     * Deletes Reachability Analysis Intent.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkManagerName The name of the network manager.
     * @param workspaceName Workspace name.
     * @param reachabilityAnalysisIntentName Reachability Analysis Intent name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String networkManagerName, String workspaceName,
        String reachabilityAnalysisIntentName) {
        deleteWithResponse(resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisIntentName,
            Context.NONE);
    }

    /**
     * Gets list of Reachability Analysis Intents .
     * 
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Reachability Analysis Intents along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ReachabilityAnalysisIntentInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<ReachabilityAnalysisIntentInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets list of Reachability Analysis Intents .
     * 
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Reachability Analysis Intents along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ReachabilityAnalysisIntentInner>> listNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
