// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VpnServerConfigurationPolicyGroupMember;
import java.io.IOException;
import java.util.List;

/**
 * Parameters for VpnServerConfigurationPolicyGroup.
 */
@Fluent
public final class VpnServerConfigurationPolicyGroupProperties
    implements JsonSerializable<VpnServerConfigurationPolicyGroupProperties> {
    /*
     * Shows if this is a Default VpnServerConfigurationPolicyGroup or not.
     */
    private Boolean isDefault;

    /*
     * Priority for VpnServerConfigurationPolicyGroup.
     */
    private Integer priority;

    /*
     * Multiple PolicyMembers for VpnServerConfigurationPolicyGroup.
     */
    private List<VpnServerConfigurationPolicyGroupMember> policyMembers;

    /*
     * List of references to P2SConnectionConfigurations.
     */
    private List<SubResource> p2SConnectionConfigurations;

    /*
     * The provisioning state of the VpnServerConfigurationPolicyGroup resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of VpnServerConfigurationPolicyGroupProperties class.
     */
    public VpnServerConfigurationPolicyGroupProperties() {
    }

    /**
     * Get the isDefault property: Shows if this is a Default VpnServerConfigurationPolicyGroup or not.
     * 
     * @return the isDefault value.
     */
    public Boolean isDefault() {
        return this.isDefault;
    }

    /**
     * Set the isDefault property: Shows if this is a Default VpnServerConfigurationPolicyGroup or not.
     * 
     * @param isDefault the isDefault value to set.
     * @return the VpnServerConfigurationPolicyGroupProperties object itself.
     */
    public VpnServerConfigurationPolicyGroupProperties withIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    /**
     * Get the priority property: Priority for VpnServerConfigurationPolicyGroup.
     * 
     * @return the priority value.
     */
    public Integer priority() {
        return this.priority;
    }

    /**
     * Set the priority property: Priority for VpnServerConfigurationPolicyGroup.
     * 
     * @param priority the priority value to set.
     * @return the VpnServerConfigurationPolicyGroupProperties object itself.
     */
    public VpnServerConfigurationPolicyGroupProperties withPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    /**
     * Get the policyMembers property: Multiple PolicyMembers for VpnServerConfigurationPolicyGroup.
     * 
     * @return the policyMembers value.
     */
    public List<VpnServerConfigurationPolicyGroupMember> policyMembers() {
        return this.policyMembers;
    }

    /**
     * Set the policyMembers property: Multiple PolicyMembers for VpnServerConfigurationPolicyGroup.
     * 
     * @param policyMembers the policyMembers value to set.
     * @return the VpnServerConfigurationPolicyGroupProperties object itself.
     */
    public VpnServerConfigurationPolicyGroupProperties
        withPolicyMembers(List<VpnServerConfigurationPolicyGroupMember> policyMembers) {
        this.policyMembers = policyMembers;
        return this;
    }

    /**
     * Get the p2SConnectionConfigurations property: List of references to P2SConnectionConfigurations.
     * 
     * @return the p2SConnectionConfigurations value.
     */
    public List<SubResource> p2SConnectionConfigurations() {
        return this.p2SConnectionConfigurations;
    }

    /**
     * Get the provisioningState property: The provisioning state of the VpnServerConfigurationPolicyGroup resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (policyMembers() != null) {
            policyMembers().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isDefault", this.isDefault);
        jsonWriter.writeNumberField("priority", this.priority);
        jsonWriter.writeArrayField("policyMembers", this.policyMembers, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VpnServerConfigurationPolicyGroupProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VpnServerConfigurationPolicyGroupProperties if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VpnServerConfigurationPolicyGroupProperties.
     */
    public static VpnServerConfigurationPolicyGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VpnServerConfigurationPolicyGroupProperties deserializedVpnServerConfigurationPolicyGroupProperties
                = new VpnServerConfigurationPolicyGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("isDefault".equals(fieldName)) {
                    deserializedVpnServerConfigurationPolicyGroupProperties.isDefault
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("priority".equals(fieldName)) {
                    deserializedVpnServerConfigurationPolicyGroupProperties.priority
                        = reader.getNullable(JsonReader::getInt);
                } else if ("policyMembers".equals(fieldName)) {
                    List<VpnServerConfigurationPolicyGroupMember> policyMembers
                        = reader.readArray(reader1 -> VpnServerConfigurationPolicyGroupMember.fromJson(reader1));
                    deserializedVpnServerConfigurationPolicyGroupProperties.policyMembers = policyMembers;
                } else if ("p2SConnectionConfigurations".equals(fieldName)) {
                    List<SubResource> p2SConnectionConfigurations
                        = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedVpnServerConfigurationPolicyGroupProperties.p2SConnectionConfigurations
                        = p2SConnectionConfigurations;
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedVpnServerConfigurationPolicyGroupProperties.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVpnServerConfigurationPolicyGroupProperties;
        });
    }
}
