// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Describes an object containing an array with a single item.
 */
@Fluent
public final class SignaturesOverridesListInner implements JsonSerializable<SignaturesOverridesListInner> {
    /*
     * Describes a list consisting exactly one item describing the policy's signature override status
     */
    private List<SignaturesOverridesInner> value;

    /**
     * Creates an instance of SignaturesOverridesListInner class.
     */
    public SignaturesOverridesListInner() {
    }

    /**
     * Get the value property: Describes a list consisting exactly one item describing the policy's signature override
     * status.
     * 
     * @return the value value.
     */
    public List<SignaturesOverridesInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Describes a list consisting exactly one item describing the policy's signature override
     * status.
     * 
     * @param value the value value to set.
     * @return the SignaturesOverridesListInner object itself.
     */
    public SignaturesOverridesListInner withValue(List<SignaturesOverridesInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SignaturesOverridesListInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SignaturesOverridesListInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SignaturesOverridesListInner.
     */
    public static SignaturesOverridesListInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SignaturesOverridesListInner deserializedSignaturesOverridesListInner = new SignaturesOverridesListInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<SignaturesOverridesInner> value
                        = reader.readArray(reader1 -> SignaturesOverridesInner.fromJson(reader1));
                    deserializedSignaturesOverridesListInner.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSignaturesOverridesListInner;
        });
    }
}
