// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.CommonProxyResource;
import com.azure.resourcemanager.network.models.ReachabilityAnalysisIntentProperties;
import java.io.IOException;

/**
 * Configuration information or intent on which to do the analysis on.
 */
@Fluent
public final class ReachabilityAnalysisIntentInner extends CommonProxyResource {
    /*
     * Represents the Reachability Analysis Intent properties.
     */
    private ReachabilityAnalysisIntentProperties properties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ReachabilityAnalysisIntentInner class.
     */
    public ReachabilityAnalysisIntentInner() {
    }

    /**
     * Get the properties property: Represents the Reachability Analysis Intent properties.
     * 
     * @return the properties value.
     */
    public ReachabilityAnalysisIntentProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Represents the Reachability Analysis Intent properties.
     * 
     * @param properties the properties value to set.
     * @return the ReachabilityAnalysisIntentInner object itself.
     */
    public ReachabilityAnalysisIntentInner withProperties(ReachabilityAnalysisIntentProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    @Override
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (properties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property properties in model ReachabilityAnalysisIntentInner"));
        } else {
            properties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ReachabilityAnalysisIntentInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ReachabilityAnalysisIntentInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ReachabilityAnalysisIntentInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ReachabilityAnalysisIntentInner.
     */
    public static ReachabilityAnalysisIntentInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ReachabilityAnalysisIntentInner deserializedReachabilityAnalysisIntentInner
                = new ReachabilityAnalysisIntentInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedReachabilityAnalysisIntentInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedReachabilityAnalysisIntentInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedReachabilityAnalysisIntentInner.type = reader.getString();
                } else if ("systemData".equals(fieldName)) {
                    deserializedReachabilityAnalysisIntentInner.systemData = SystemData.fromJson(reader);
                } else if ("properties".equals(fieldName)) {
                    deserializedReachabilityAnalysisIntentInner.properties
                        = ReachabilityAnalysisIntentProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedReachabilityAnalysisIntentInner;
        });
    }
}
