// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.RadiusAuthServer;
import java.io.IOException;
import java.util.List;

/**
 * List of Radius servers with respective radius secrets.
 */
@Fluent
public final class RadiusAuthServerListResultInner implements JsonSerializable<RadiusAuthServerListResultInner> {
    /*
     * List of Radius servers with respective radius secrets.
     */
    private List<RadiusAuthServer> value;

    /*
     * URL to get the next set of operation list results if there are any.
     */
    private String nextLink;

    /**
     * Creates an instance of RadiusAuthServerListResultInner class.
     */
    public RadiusAuthServerListResultInner() {
    }

    /**
     * Get the value property: List of Radius servers with respective radius secrets.
     * 
     * @return the value value.
     */
    public List<RadiusAuthServer> value() {
        return this.value;
    }

    /**
     * Set the value property: List of Radius servers with respective radius secrets.
     * 
     * @param value the value value to set.
     * @return the RadiusAuthServerListResultInner object itself.
     */
    public RadiusAuthServerListResultInner withValue(List<RadiusAuthServer> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: URL to get the next set of operation list results if there are any.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: URL to get the next set of operation list results if there are any.
     * 
     * @param nextLink the nextLink value to set.
     * @return the RadiusAuthServerListResultInner object itself.
     */
    public RadiusAuthServerListResultInner withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RadiusAuthServerListResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RadiusAuthServerListResultInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RadiusAuthServerListResultInner.
     */
    public static RadiusAuthServerListResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RadiusAuthServerListResultInner deserializedRadiusAuthServerListResultInner
                = new RadiusAuthServerListResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<RadiusAuthServer> value = reader.readArray(reader1 -> RadiusAuthServer.fromJson(reader1));
                    deserializedRadiusAuthServerListResultInner.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedRadiusAuthServerListResultInner.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRadiusAuthServerListResultInner;
        });
    }
}
