// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.PrivateDnsZoneConfig;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * Private dns zone group resource.
 */
@Fluent
public final class PrivateDnsZoneGroupInner extends SubResource {
    /*
     * Name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    private String name;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    private String etag;

    /*
     * Properties of the private dns zone group.
     */
    private PrivateDnsZoneGroupPropertiesFormat innerProperties;

    /**
     * Creates an instance of PrivateDnsZoneGroupInner class.
     */
    public PrivateDnsZoneGroupInner() {
    }

    /**
     * Get the name property: Name of the resource that is unique within a resource group. This name can be used to
     * access the resource.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the resource that is unique within a resource group. This name can be used to
     * access the resource.
     * 
     * @param name the name value to set.
     * @return the PrivateDnsZoneGroupInner object itself.
     */
    public PrivateDnsZoneGroupInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the innerProperties property: Properties of the private dns zone group.
     * 
     * @return the innerProperties value.
     */
    private PrivateDnsZoneGroupPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public PrivateDnsZoneGroupInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the private dns zone group resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the privateDnsZoneConfigs property: A collection of private dns zone configurations of the private dns zone
     * group.
     * 
     * @return the privateDnsZoneConfigs value.
     */
    public List<PrivateDnsZoneConfig> privateDnsZoneConfigs() {
        return this.innerProperties() == null ? null : this.innerProperties().privateDnsZoneConfigs();
    }

    /**
     * Set the privateDnsZoneConfigs property: A collection of private dns zone configurations of the private dns zone
     * group.
     * 
     * @param privateDnsZoneConfigs the privateDnsZoneConfigs value to set.
     * @return the PrivateDnsZoneGroupInner object itself.
     */
    public PrivateDnsZoneGroupInner withPrivateDnsZoneConfigs(List<PrivateDnsZoneConfig> privateDnsZoneConfigs) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateDnsZoneGroupPropertiesFormat();
        }
        this.innerProperties().withPrivateDnsZoneConfigs(privateDnsZoneConfigs);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PrivateDnsZoneGroupInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PrivateDnsZoneGroupInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PrivateDnsZoneGroupInner.
     */
    public static PrivateDnsZoneGroupInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PrivateDnsZoneGroupInner deserializedPrivateDnsZoneGroupInner = new PrivateDnsZoneGroupInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedPrivateDnsZoneGroupInner.withId(reader.getString());
                } else if ("name".equals(fieldName)) {
                    deserializedPrivateDnsZoneGroupInner.name = reader.getString();
                } else if ("etag".equals(fieldName)) {
                    deserializedPrivateDnsZoneGroupInner.etag = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedPrivateDnsZoneGroupInner.innerProperties
                        = PrivateDnsZoneGroupPropertiesFormat.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPrivateDnsZoneGroupInner;
        });
    }
}
