// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties of NSP profile.
 */
@Immutable
public final class NspProfileProperties implements JsonSerializable<NspProfileProperties> {
    /*
     * Version number that increases with every update to access rules within the profile.
     */
    private String accessRulesVersion;

    /*
     * Version number that increases with every update to diagnostic settings within the profile.
     */
    private String diagnosticSettingsVersion;

    /**
     * Creates an instance of NspProfileProperties class.
     */
    public NspProfileProperties() {
    }

    /**
     * Get the accessRulesVersion property: Version number that increases with every update to access rules within the
     * profile.
     * 
     * @return the accessRulesVersion value.
     */
    public String accessRulesVersion() {
        return this.accessRulesVersion;
    }

    /**
     * Get the diagnosticSettingsVersion property: Version number that increases with every update to diagnostic
     * settings within the profile.
     * 
     * @return the diagnosticSettingsVersion value.
     */
    public String diagnosticSettingsVersion() {
        return this.diagnosticSettingsVersion;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NspProfileProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NspProfileProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NspProfileProperties.
     */
    public static NspProfileProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NspProfileProperties deserializedNspProfileProperties = new NspProfileProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("accessRulesVersion".equals(fieldName)) {
                    deserializedNspProfileProperties.accessRulesVersion = reader.getString();
                } else if ("diagnosticSettingsVersion".equals(fieldName)) {
                    deserializedNspProfileProperties.diagnosticSettingsVersion = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNspProfileProperties;
        });
    }
}
