// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The NSP logging configuration properties.
 */
@Fluent
public final class NspLoggingConfigurationProperties implements JsonSerializable<NspLoggingConfigurationProperties> {
    /*
     * The log categories to enable in the NSP logging configuration.
     */
    private List<String> enabledLogCategories;

    /*
     * The version of the NSP logging configuration.
     */
    private String version;

    /**
     * Creates an instance of NspLoggingConfigurationProperties class.
     */
    public NspLoggingConfigurationProperties() {
    }

    /**
     * Get the enabledLogCategories property: The log categories to enable in the NSP logging configuration.
     * 
     * @return the enabledLogCategories value.
     */
    public List<String> enabledLogCategories() {
        return this.enabledLogCategories;
    }

    /**
     * Set the enabledLogCategories property: The log categories to enable in the NSP logging configuration.
     * 
     * @param enabledLogCategories the enabledLogCategories value to set.
     * @return the NspLoggingConfigurationProperties object itself.
     */
    public NspLoggingConfigurationProperties withEnabledLogCategories(List<String> enabledLogCategories) {
        this.enabledLogCategories = enabledLogCategories;
        return this;
    }

    /**
     * Get the version property: The version of the NSP logging configuration.
     * 
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Set the version property: The version of the NSP logging configuration.
     * 
     * @param version the version value to set.
     * @return the NspLoggingConfigurationProperties object itself.
     */
    public NspLoggingConfigurationProperties withVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("enabledLogCategories", this.enabledLogCategories,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("version", this.version);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NspLoggingConfigurationProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NspLoggingConfigurationProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NspLoggingConfigurationProperties.
     */
    public static NspLoggingConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NspLoggingConfigurationProperties deserializedNspLoggingConfigurationProperties
                = new NspLoggingConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabledLogCategories".equals(fieldName)) {
                    List<String> enabledLogCategories = reader.readArray(reader1 -> reader1.getString());
                    deserializedNspLoggingConfigurationProperties.enabledLogCategories = enabledLogCategories;
                } else if ("version".equals(fieldName)) {
                    deserializedNspLoggingConfigurationProperties.version = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNspLoggingConfigurationProperties;
        });
    }
}
