// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ConfigurationType;
import java.io.IOException;
import java.util.List;

/**
 * Network Manager Commit.
 */
@Fluent
public final class NetworkManagerCommitInner implements JsonSerializable<NetworkManagerCommitInner> {
    /*
     * Commit Id.
     */
    private String commitId;

    /*
     * List of target locations.
     */
    private List<String> targetLocations;

    /*
     * List of configuration ids.
     */
    private List<String> configurationIds;

    /*
     * Commit Type.
     */
    private ConfigurationType commitType;

    /**
     * Creates an instance of NetworkManagerCommitInner class.
     */
    public NetworkManagerCommitInner() {
    }

    /**
     * Get the commitId property: Commit Id.
     * 
     * @return the commitId value.
     */
    public String commitId() {
        return this.commitId;
    }

    /**
     * Get the targetLocations property: List of target locations.
     * 
     * @return the targetLocations value.
     */
    public List<String> targetLocations() {
        return this.targetLocations;
    }

    /**
     * Set the targetLocations property: List of target locations.
     * 
     * @param targetLocations the targetLocations value to set.
     * @return the NetworkManagerCommitInner object itself.
     */
    public NetworkManagerCommitInner withTargetLocations(List<String> targetLocations) {
        this.targetLocations = targetLocations;
        return this;
    }

    /**
     * Get the configurationIds property: List of configuration ids.
     * 
     * @return the configurationIds value.
     */
    public List<String> configurationIds() {
        return this.configurationIds;
    }

    /**
     * Set the configurationIds property: List of configuration ids.
     * 
     * @param configurationIds the configurationIds value to set.
     * @return the NetworkManagerCommitInner object itself.
     */
    public NetworkManagerCommitInner withConfigurationIds(List<String> configurationIds) {
        this.configurationIds = configurationIds;
        return this;
    }

    /**
     * Get the commitType property: Commit Type.
     * 
     * @return the commitType value.
     */
    public ConfigurationType commitType() {
        return this.commitType;
    }

    /**
     * Set the commitType property: Commit Type.
     * 
     * @param commitType the commitType value to set.
     * @return the NetworkManagerCommitInner object itself.
     */
    public NetworkManagerCommitInner withCommitType(ConfigurationType commitType) {
        this.commitType = commitType;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (targetLocations() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property targetLocations in model NetworkManagerCommitInner"));
        }
        if (commitType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property commitType in model NetworkManagerCommitInner"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(NetworkManagerCommitInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("targetLocations", this.targetLocations,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("commitType", this.commitType == null ? null : this.commitType.toString());
        jsonWriter.writeArrayField("configurationIds", this.configurationIds,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkManagerCommitInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkManagerCommitInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the NetworkManagerCommitInner.
     */
    public static NetworkManagerCommitInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkManagerCommitInner deserializedNetworkManagerCommitInner = new NetworkManagerCommitInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("targetLocations".equals(fieldName)) {
                    List<String> targetLocations = reader.readArray(reader1 -> reader1.getString());
                    deserializedNetworkManagerCommitInner.targetLocations = targetLocations;
                } else if ("commitType".equals(fieldName)) {
                    deserializedNetworkManagerCommitInner.commitType = ConfigurationType.fromString(reader.getString());
                } else if ("commitId".equals(fieldName)) {
                    deserializedNetworkManagerCommitInner.commitId = reader.getString();
                } else if ("configurationIds".equals(fieldName)) {
                    List<String> configurationIds = reader.readArray(reader1 -> reader1.getString());
                    deserializedNetworkManagerCommitInner.configurationIds = configurationIds;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkManagerCommitInner;
        });
    }
}
