// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

/**
 * Properties of Virtual Network Tap configuration.
 */
@Fluent
public final class NetworkInterfaceTapConfigurationPropertiesFormatInner
    implements JsonSerializable<NetworkInterfaceTapConfigurationPropertiesFormatInner> {
    /*
     * The reference to the Virtual Network Tap resource.
     */
    private VirtualNetworkTapInner virtualNetworkTap;

    /*
     * The provisioning state of the network interface tap configuration resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of NetworkInterfaceTapConfigurationPropertiesFormatInner class.
     */
    public NetworkInterfaceTapConfigurationPropertiesFormatInner() {
    }

    /**
     * Get the virtualNetworkTap property: The reference to the Virtual Network Tap resource.
     * 
     * @return the virtualNetworkTap value.
     */
    public VirtualNetworkTapInner virtualNetworkTap() {
        return this.virtualNetworkTap;
    }

    /**
     * Set the virtualNetworkTap property: The reference to the Virtual Network Tap resource.
     * 
     * @param virtualNetworkTap the virtualNetworkTap value to set.
     * @return the NetworkInterfaceTapConfigurationPropertiesFormatInner object itself.
     */
    public NetworkInterfaceTapConfigurationPropertiesFormatInner
        withVirtualNetworkTap(VirtualNetworkTapInner virtualNetworkTap) {
        this.virtualNetworkTap = virtualNetworkTap;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the network interface tap configuration resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (virtualNetworkTap() != null) {
            virtualNetworkTap().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("virtualNetworkTap", this.virtualNetworkTap);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkInterfaceTapConfigurationPropertiesFormatInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkInterfaceTapConfigurationPropertiesFormatInner if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetworkInterfaceTapConfigurationPropertiesFormatInner.
     */
    public static NetworkInterfaceTapConfigurationPropertiesFormatInner fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkInterfaceTapConfigurationPropertiesFormatInner deserializedNetworkInterfaceTapConfigurationPropertiesFormatInner
                = new NetworkInterfaceTapConfigurationPropertiesFormatInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("virtualNetworkTap".equals(fieldName)) {
                    deserializedNetworkInterfaceTapConfigurationPropertiesFormatInner.virtualNetworkTap
                        = VirtualNetworkTapInner.fromJson(reader);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedNetworkInterfaceTapConfigurationPropertiesFormatInner.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkInterfaceTapConfigurationPropertiesFormatInner;
        });
    }
}
