// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.InboundSecurityRuleType;
import com.azure.resourcemanager.network.models.InboundSecurityRules;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * NVA Inbound Security Rule resource.
 */
@Fluent
public final class InboundSecurityRuleInner extends SubResource {
    /*
     * The properties of the Inbound Security Rules.
     */
    private InboundSecurityRuleProperties innerProperties;

    /*
     * Name of security rule collection.
     */
    private String name;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    private String etag;

    /*
     * NVA inbound security rule type.
     */
    private String type;

    /**
     * Creates an instance of InboundSecurityRuleInner class.
     */
    public InboundSecurityRuleInner() {
    }

    /**
     * Get the innerProperties property: The properties of the Inbound Security Rules.
     * 
     * @return the innerProperties value.
     */
    private InboundSecurityRuleProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the name property: Name of security rule collection.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of security rule collection.
     * 
     * @param name the name value to set.
     * @return the InboundSecurityRuleInner object itself.
     */
    public InboundSecurityRuleInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: NVA inbound security rule type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public InboundSecurityRuleInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the ruleType property: Rule Type. This should be either AutoExpire or Permanent. Auto Expire Rule only
     * creates NSG rules. Permanent Rule creates NSG rule and SLB LB Rule.
     * 
     * @return the ruleType value.
     */
    public InboundSecurityRuleType ruleType() {
        return this.innerProperties() == null ? null : this.innerProperties().ruleType();
    }

    /**
     * Set the ruleType property: Rule Type. This should be either AutoExpire or Permanent. Auto Expire Rule only
     * creates NSG rules. Permanent Rule creates NSG rule and SLB LB Rule.
     * 
     * @param ruleType the ruleType value to set.
     * @return the InboundSecurityRuleInner object itself.
     */
    public InboundSecurityRuleInner withRuleType(InboundSecurityRuleType ruleType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InboundSecurityRuleProperties();
        }
        this.innerProperties().withRuleType(ruleType);
        return this;
    }

    /**
     * Get the rules property: List of allowed rules.
     * 
     * @return the rules value.
     */
    public List<InboundSecurityRules> rules() {
        return this.innerProperties() == null ? null : this.innerProperties().rules();
    }

    /**
     * Set the rules property: List of allowed rules.
     * 
     * @param rules the rules value to set.
     * @return the InboundSecurityRuleInner object itself.
     */
    public InboundSecurityRuleInner withRules(List<InboundSecurityRules> rules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InboundSecurityRuleProperties();
        }
        this.innerProperties().withRules(rules);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of InboundSecurityRuleInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of InboundSecurityRuleInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the InboundSecurityRuleInner.
     */
    public static InboundSecurityRuleInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            InboundSecurityRuleInner deserializedInboundSecurityRuleInner = new InboundSecurityRuleInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedInboundSecurityRuleInner.withId(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedInboundSecurityRuleInner.innerProperties
                        = InboundSecurityRuleProperties.fromJson(reader);
                } else if ("name".equals(fieldName)) {
                    deserializedInboundSecurityRuleInner.name = reader.getString();
                } else if ("etag".equals(fieldName)) {
                    deserializedInboundSecurityRuleInner.etag = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedInboundSecurityRuleInner.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedInboundSecurityRuleInner;
        });
    }
}
