// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.TransportProtocol;
import java.io.IOException;

/**
 * Inbound NAT rule of the load balancer.
 */
@Fluent
public final class InboundNatRuleInner extends SubResource {
    /*
     * Properties of load balancer inbound NAT rule.
     */
    private InboundNatRulePropertiesFormatInner innerProperties;

    /*
     * The name of the resource that is unique within the set of inbound NAT rules used by the load balancer. This name
     * can be used to access the resource.
     */
    private String name;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    private String etag;

    /*
     * Type of the resource.
     */
    private String type;

    /**
     * Creates an instance of InboundNatRuleInner class.
     */
    public InboundNatRuleInner() {
    }

    /**
     * Get the innerProperties property: Properties of load balancer inbound NAT rule.
     * 
     * @return the innerProperties value.
     */
    private InboundNatRulePropertiesFormatInner innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the name property: The name of the resource that is unique within the set of inbound NAT rules used by the
     * load balancer. This name can be used to access the resource.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the resource that is unique within the set of inbound NAT rules used by the
     * load balancer. This name can be used to access the resource.
     * 
     * @param name the name value to set.
     * @return the InboundNatRuleInner object itself.
     */
    public InboundNatRuleInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: Type of the resource.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public InboundNatRuleInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the frontendIpConfiguration property: A reference to frontend IP addresses.
     * 
     * @return the frontendIpConfiguration value.
     */
    public SubResource frontendIpConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().frontendIpConfiguration();
    }

    /**
     * Set the frontendIpConfiguration property: A reference to frontend IP addresses.
     * 
     * @param frontendIpConfiguration the frontendIpConfiguration value to set.
     * @return the InboundNatRuleInner object itself.
     */
    public InboundNatRuleInner withFrontendIpConfiguration(SubResource frontendIpConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InboundNatRulePropertiesFormatInner();
        }
        this.innerProperties().withFrontendIpConfiguration(frontendIpConfiguration);
        return this;
    }

    /**
     * Get the backendIpConfiguration property: A reference to a private IP address defined on a network interface of a
     * VM. Traffic sent to the frontend port of each of the frontend IP configurations is forwarded to the backend IP.
     * 
     * @return the backendIpConfiguration value.
     */
    public NetworkInterfaceIpConfigurationInner backendIpConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().backendIpConfiguration();
    }

    /**
     * Get the protocol property: The reference to the transport protocol used by the load balancing rule.
     * 
     * @return the protocol value.
     */
    public TransportProtocol protocol() {
        return this.innerProperties() == null ? null : this.innerProperties().protocol();
    }

    /**
     * Set the protocol property: The reference to the transport protocol used by the load balancing rule.
     * 
     * @param protocol the protocol value to set.
     * @return the InboundNatRuleInner object itself.
     */
    public InboundNatRuleInner withProtocol(TransportProtocol protocol) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InboundNatRulePropertiesFormatInner();
        }
        this.innerProperties().withProtocol(protocol);
        return this;
    }

    /**
     * Get the frontendPort property: The port for the external endpoint. Port numbers for each rule must be unique
     * within the Load Balancer. Acceptable values range from 1 to 65534.
     * 
     * @return the frontendPort value.
     */
    public Integer frontendPort() {
        return this.innerProperties() == null ? null : this.innerProperties().frontendPort();
    }

    /**
     * Set the frontendPort property: The port for the external endpoint. Port numbers for each rule must be unique
     * within the Load Balancer. Acceptable values range from 1 to 65534.
     * 
     * @param frontendPort the frontendPort value to set.
     * @return the InboundNatRuleInner object itself.
     */
    public InboundNatRuleInner withFrontendPort(Integer frontendPort) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InboundNatRulePropertiesFormatInner();
        }
        this.innerProperties().withFrontendPort(frontendPort);
        return this;
    }

    /**
     * Get the backendPort property: The port used for the internal endpoint. Acceptable values range from 1 to 65535.
     * 
     * @return the backendPort value.
     */
    public Integer backendPort() {
        return this.innerProperties() == null ? null : this.innerProperties().backendPort();
    }

    /**
     * Set the backendPort property: The port used for the internal endpoint. Acceptable values range from 1 to 65535.
     * 
     * @param backendPort the backendPort value to set.
     * @return the InboundNatRuleInner object itself.
     */
    public InboundNatRuleInner withBackendPort(Integer backendPort) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InboundNatRulePropertiesFormatInner();
        }
        this.innerProperties().withBackendPort(backendPort);
        return this;
    }

    /**
     * Get the idleTimeoutInMinutes property: The timeout for the TCP idle connection. The value can be set between 4
     * and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
     * 
     * @return the idleTimeoutInMinutes value.
     */
    public Integer idleTimeoutInMinutes() {
        return this.innerProperties() == null ? null : this.innerProperties().idleTimeoutInMinutes();
    }

    /**
     * Set the idleTimeoutInMinutes property: The timeout for the TCP idle connection. The value can be set between 4
     * and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
     * 
     * @param idleTimeoutInMinutes the idleTimeoutInMinutes value to set.
     * @return the InboundNatRuleInner object itself.
     */
    public InboundNatRuleInner withIdleTimeoutInMinutes(Integer idleTimeoutInMinutes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InboundNatRulePropertiesFormatInner();
        }
        this.innerProperties().withIdleTimeoutInMinutes(idleTimeoutInMinutes);
        return this;
    }

    /**
     * Get the enableFloatingIp property: Configures a virtual machine's endpoint for the floating IP capability
     * required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn
     * Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
     * 
     * @return the enableFloatingIp value.
     */
    public Boolean enableFloatingIp() {
        return this.innerProperties() == null ? null : this.innerProperties().enableFloatingIp();
    }

    /**
     * Set the enableFloatingIp property: Configures a virtual machine's endpoint for the floating IP capability
     * required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn
     * Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
     * 
     * @param enableFloatingIp the enableFloatingIp value to set.
     * @return the InboundNatRuleInner object itself.
     */
    public InboundNatRuleInner withEnableFloatingIp(Boolean enableFloatingIp) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InboundNatRulePropertiesFormatInner();
        }
        this.innerProperties().withEnableFloatingIp(enableFloatingIp);
        return this;
    }

    /**
     * Get the enableTcpReset property: Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected
     * connection termination. This element is only used when the protocol is set to TCP.
     * 
     * @return the enableTcpReset value.
     */
    public Boolean enableTcpReset() {
        return this.innerProperties() == null ? null : this.innerProperties().enableTcpReset();
    }

    /**
     * Set the enableTcpReset property: Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected
     * connection termination. This element is only used when the protocol is set to TCP.
     * 
     * @param enableTcpReset the enableTcpReset value to set.
     * @return the InboundNatRuleInner object itself.
     */
    public InboundNatRuleInner withEnableTcpReset(Boolean enableTcpReset) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InboundNatRulePropertiesFormatInner();
        }
        this.innerProperties().withEnableTcpReset(enableTcpReset);
        return this;
    }

    /**
     * Get the frontendPortRangeStart property: The port range start for the external endpoint. This property is used
     * together with BackendAddressPool and FrontendPortRangeEnd. Individual inbound NAT rule port mappings will be
     * created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534.
     * 
     * @return the frontendPortRangeStart value.
     */
    public Integer frontendPortRangeStart() {
        return this.innerProperties() == null ? null : this.innerProperties().frontendPortRangeStart();
    }

    /**
     * Set the frontendPortRangeStart property: The port range start for the external endpoint. This property is used
     * together with BackendAddressPool and FrontendPortRangeEnd. Individual inbound NAT rule port mappings will be
     * created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534.
     * 
     * @param frontendPortRangeStart the frontendPortRangeStart value to set.
     * @return the InboundNatRuleInner object itself.
     */
    public InboundNatRuleInner withFrontendPortRangeStart(Integer frontendPortRangeStart) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InboundNatRulePropertiesFormatInner();
        }
        this.innerProperties().withFrontendPortRangeStart(frontendPortRangeStart);
        return this;
    }

    /**
     * Get the frontendPortRangeEnd property: The port range end for the external endpoint. This property is used
     * together with BackendAddressPool and FrontendPortRangeStart. Individual inbound NAT rule port mappings will be
     * created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534.
     * 
     * @return the frontendPortRangeEnd value.
     */
    public Integer frontendPortRangeEnd() {
        return this.innerProperties() == null ? null : this.innerProperties().frontendPortRangeEnd();
    }

    /**
     * Set the frontendPortRangeEnd property: The port range end for the external endpoint. This property is used
     * together with BackendAddressPool and FrontendPortRangeStart. Individual inbound NAT rule port mappings will be
     * created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534.
     * 
     * @param frontendPortRangeEnd the frontendPortRangeEnd value to set.
     * @return the InboundNatRuleInner object itself.
     */
    public InboundNatRuleInner withFrontendPortRangeEnd(Integer frontendPortRangeEnd) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InboundNatRulePropertiesFormatInner();
        }
        this.innerProperties().withFrontendPortRangeEnd(frontendPortRangeEnd);
        return this;
    }

    /**
     * Get the backendAddressPool property: A reference to backendAddressPool resource.
     * 
     * @return the backendAddressPool value.
     */
    public SubResource backendAddressPool() {
        return this.innerProperties() == null ? null : this.innerProperties().backendAddressPool();
    }

    /**
     * Set the backendAddressPool property: A reference to backendAddressPool resource.
     * 
     * @param backendAddressPool the backendAddressPool value to set.
     * @return the InboundNatRuleInner object itself.
     */
    public InboundNatRuleInner withBackendAddressPool(SubResource backendAddressPool) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InboundNatRulePropertiesFormatInner();
        }
        this.innerProperties().withBackendAddressPool(backendAddressPool);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the inbound NAT rule resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of InboundNatRuleInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of InboundNatRuleInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the InboundNatRuleInner.
     */
    public static InboundNatRuleInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            InboundNatRuleInner deserializedInboundNatRuleInner = new InboundNatRuleInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedInboundNatRuleInner.withId(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedInboundNatRuleInner.innerProperties
                        = InboundNatRulePropertiesFormatInner.fromJson(reader);
                } else if ("name".equals(fieldName)) {
                    deserializedInboundNatRuleInner.name = reader.getString();
                } else if ("etag".equals(fieldName)) {
                    deserializedInboundNatRuleInner.etag = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedInboundNatRuleInner.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedInboundNatRuleInner;
        });
    }
}
