// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.GatewayRoute;
import java.io.IOException;
import java.util.List;

/**
 * List of virtual network gateway routes.
 */
@Fluent
public final class GatewayRouteListResultInner implements JsonSerializable<GatewayRouteListResultInner> {
    /*
     * List of gateway routes.
     */
    private List<GatewayRoute> value;

    /**
     * Creates an instance of GatewayRouteListResultInner class.
     */
    public GatewayRouteListResultInner() {
    }

    /**
     * Get the value property: List of gateway routes.
     * 
     * @return the value value.
     */
    public List<GatewayRoute> value() {
        return this.value;
    }

    /**
     * Set the value property: List of gateway routes.
     * 
     * @param value the value value to set.
     * @return the GatewayRouteListResultInner object itself.
     */
    public GatewayRouteListResultInner withValue(List<GatewayRoute> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GatewayRouteListResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GatewayRouteListResultInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GatewayRouteListResultInner.
     */
    public static GatewayRouteListResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GatewayRouteListResultInner deserializedGatewayRouteListResultInner = new GatewayRouteListResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<GatewayRoute> value = reader.readArray(reader1 -> GatewayRoute.fromJson(reader1));
                    deserializedGatewayRouteListResultInner.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGatewayRouteListResultInner;
        });
    }
}
