// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.FlowLogFormatParameters;
import com.azure.resourcemanager.network.models.RetentionPolicyParameters;
import java.io.IOException;

/**
 * Parameters that define the configuration of flow log.
 */
@Fluent
public final class FlowLogProperties implements JsonSerializable<FlowLogProperties> {
    /*
     * ID of the storage account which is used to store the flow log.
     */
    private String storageId;

    /*
     * Optional field to filter network traffic logs based on SrcIP, SrcPort, DstIP, DstPort, Protocol, Encryption,
     * Direction and Action. If not specified, all network traffic will be logged.
     */
    private String enabledFilteringCriteria;

    /*
     * Optional field to filter network traffic logs based on flow states. Value of this field could be any comma
     * separated combination string of letters B,C,E or D. B represents Begin, when a flow is created. C represents
     * Continue for an ongoing flow generated at every five-minute interval. E represents End, when a flow is
     * terminated. D represents Deny, when a flow is denied. If not specified, all network traffic will be logged.
     */
    private String recordTypes;

    /*
     * Flag to enable/disable flow logging.
     */
    private boolean enabled;

    /*
     * Parameters that define the retention policy for flow log.
     */
    private RetentionPolicyParameters retentionPolicy;

    /*
     * Parameters that define the flow log format.
     */
    private FlowLogFormatParameters format;

    /**
     * Creates an instance of FlowLogProperties class.
     */
    public FlowLogProperties() {
    }

    /**
     * Get the storageId property: ID of the storage account which is used to store the flow log.
     * 
     * @return the storageId value.
     */
    public String storageId() {
        return this.storageId;
    }

    /**
     * Set the storageId property: ID of the storage account which is used to store the flow log.
     * 
     * @param storageId the storageId value to set.
     * @return the FlowLogProperties object itself.
     */
    public FlowLogProperties withStorageId(String storageId) {
        this.storageId = storageId;
        return this;
    }

    /**
     * Get the enabledFilteringCriteria property: Optional field to filter network traffic logs based on SrcIP, SrcPort,
     * DstIP, DstPort, Protocol, Encryption, Direction and Action. If not specified, all network traffic will be logged.
     * 
     * @return the enabledFilteringCriteria value.
     */
    public String enabledFilteringCriteria() {
        return this.enabledFilteringCriteria;
    }

    /**
     * Set the enabledFilteringCriteria property: Optional field to filter network traffic logs based on SrcIP, SrcPort,
     * DstIP, DstPort, Protocol, Encryption, Direction and Action. If not specified, all network traffic will be logged.
     * 
     * @param enabledFilteringCriteria the enabledFilteringCriteria value to set.
     * @return the FlowLogProperties object itself.
     */
    public FlowLogProperties withEnabledFilteringCriteria(String enabledFilteringCriteria) {
        this.enabledFilteringCriteria = enabledFilteringCriteria;
        return this;
    }

    /**
     * Get the recordTypes property: Optional field to filter network traffic logs based on flow states. Value of this
     * field could be any comma separated combination string of letters B,C,E or D. B represents Begin, when a flow is
     * created. C represents Continue for an ongoing flow generated at every five-minute interval. E represents End,
     * when a flow is terminated. D represents Deny, when a flow is denied. If not specified, all network traffic will
     * be logged.
     * 
     * @return the recordTypes value.
     */
    public String recordTypes() {
        return this.recordTypes;
    }

    /**
     * Set the recordTypes property: Optional field to filter network traffic logs based on flow states. Value of this
     * field could be any comma separated combination string of letters B,C,E or D. B represents Begin, when a flow is
     * created. C represents Continue for an ongoing flow generated at every five-minute interval. E represents End,
     * when a flow is terminated. D represents Deny, when a flow is denied. If not specified, all network traffic will
     * be logged.
     * 
     * @param recordTypes the recordTypes value to set.
     * @return the FlowLogProperties object itself.
     */
    public FlowLogProperties withRecordTypes(String recordTypes) {
        this.recordTypes = recordTypes;
        return this;
    }

    /**
     * Get the enabled property: Flag to enable/disable flow logging.
     * 
     * @return the enabled value.
     */
    public boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Flag to enable/disable flow logging.
     * 
     * @param enabled the enabled value to set.
     * @return the FlowLogProperties object itself.
     */
    public FlowLogProperties withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the retentionPolicy property: Parameters that define the retention policy for flow log.
     * 
     * @return the retentionPolicy value.
     */
    public RetentionPolicyParameters retentionPolicy() {
        return this.retentionPolicy;
    }

    /**
     * Set the retentionPolicy property: Parameters that define the retention policy for flow log.
     * 
     * @param retentionPolicy the retentionPolicy value to set.
     * @return the FlowLogProperties object itself.
     */
    public FlowLogProperties withRetentionPolicy(RetentionPolicyParameters retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    /**
     * Get the format property: Parameters that define the flow log format.
     * 
     * @return the format value.
     */
    public FlowLogFormatParameters format() {
        return this.format;
    }

    /**
     * Set the format property: Parameters that define the flow log format.
     * 
     * @param format the format value to set.
     * @return the FlowLogProperties object itself.
     */
    public FlowLogProperties withFormat(FlowLogFormatParameters format) {
        this.format = format;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (storageId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property storageId in model FlowLogProperties"));
        }
        if (retentionPolicy() != null) {
            retentionPolicy().validate();
        }
        if (format() != null) {
            format().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(FlowLogProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageId", this.storageId);
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("enabledFilteringCriteria", this.enabledFilteringCriteria);
        jsonWriter.writeStringField("recordTypes", this.recordTypes);
        jsonWriter.writeJsonField("retentionPolicy", this.retentionPolicy);
        jsonWriter.writeJsonField("format", this.format);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FlowLogProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FlowLogProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the FlowLogProperties.
     */
    public static FlowLogProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FlowLogProperties deserializedFlowLogProperties = new FlowLogProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("storageId".equals(fieldName)) {
                    deserializedFlowLogProperties.storageId = reader.getString();
                } else if ("enabled".equals(fieldName)) {
                    deserializedFlowLogProperties.enabled = reader.getBoolean();
                } else if ("enabledFilteringCriteria".equals(fieldName)) {
                    deserializedFlowLogProperties.enabledFilteringCriteria = reader.getString();
                } else if ("recordTypes".equals(fieldName)) {
                    deserializedFlowLogProperties.recordTypes = reader.getString();
                } else if ("retentionPolicy".equals(fieldName)) {
                    deserializedFlowLogProperties.retentionPolicy = RetentionPolicyParameters.fromJson(reader);
                } else if ("format".equals(fieldName)) {
                    deserializedFlowLogProperties.format = FlowLogFormatParameters.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFlowLogProperties;
        });
    }
}
