// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ExpressRouteFailoverRedundantRoute;
import com.azure.resourcemanager.network.models.FailoverConnectionDetails;
import com.azure.resourcemanager.network.models.FailoverTestStatusForSingleTest;
import java.io.IOException;
import java.util.List;

/**
 * ExpressRoute failover single test details.
 */
@Fluent
public final class ExpressRouteFailoverSingleTestDetailsInner
    implements JsonSerializable<ExpressRouteFailoverSingleTestDetailsInner> {
    /*
     * Peering location of the test
     */
    private String peeringLocation;

    /*
     * The current status of the test
     */
    private FailoverTestStatusForSingleTest status;

    /*
     * Time when the test was started
     */
    private String startTimeUtc;

    /*
     * Time when the test was completed
     */
    private String endTimeUtc;

    /*
     * List of routes received from this peering as well as some other peering location
     */
    private List<ExpressRouteFailoverRedundantRoute> redundantRoutes;

    /*
     * List of al the routes that were received only from this peering location
     */
    private List<String> nonRedundantRoutes;

    /*
     * Whether the failover simulation was successful or not
     */
    private Boolean wasSimulationSuccessful;

    /*
     * List of all the failover connections for this peering location
     */
    private List<FailoverConnectionDetails> failoverConnectionDetails;

    /**
     * Creates an instance of ExpressRouteFailoverSingleTestDetailsInner class.
     */
    public ExpressRouteFailoverSingleTestDetailsInner() {
    }

    /**
     * Get the peeringLocation property: Peering location of the test.
     * 
     * @return the peeringLocation value.
     */
    public String peeringLocation() {
        return this.peeringLocation;
    }

    /**
     * Set the peeringLocation property: Peering location of the test.
     * 
     * @param peeringLocation the peeringLocation value to set.
     * @return the ExpressRouteFailoverSingleTestDetailsInner object itself.
     */
    public ExpressRouteFailoverSingleTestDetailsInner withPeeringLocation(String peeringLocation) {
        this.peeringLocation = peeringLocation;
        return this;
    }

    /**
     * Get the status property: The current status of the test.
     * 
     * @return the status value.
     */
    public FailoverTestStatusForSingleTest status() {
        return this.status;
    }

    /**
     * Set the status property: The current status of the test.
     * 
     * @param status the status value to set.
     * @return the ExpressRouteFailoverSingleTestDetailsInner object itself.
     */
    public ExpressRouteFailoverSingleTestDetailsInner withStatus(FailoverTestStatusForSingleTest status) {
        this.status = status;
        return this;
    }

    /**
     * Get the startTimeUtc property: Time when the test was started.
     * 
     * @return the startTimeUtc value.
     */
    public String startTimeUtc() {
        return this.startTimeUtc;
    }

    /**
     * Set the startTimeUtc property: Time when the test was started.
     * 
     * @param startTimeUtc the startTimeUtc value to set.
     * @return the ExpressRouteFailoverSingleTestDetailsInner object itself.
     */
    public ExpressRouteFailoverSingleTestDetailsInner withStartTimeUtc(String startTimeUtc) {
        this.startTimeUtc = startTimeUtc;
        return this;
    }

    /**
     * Get the endTimeUtc property: Time when the test was completed.
     * 
     * @return the endTimeUtc value.
     */
    public String endTimeUtc() {
        return this.endTimeUtc;
    }

    /**
     * Set the endTimeUtc property: Time when the test was completed.
     * 
     * @param endTimeUtc the endTimeUtc value to set.
     * @return the ExpressRouteFailoverSingleTestDetailsInner object itself.
     */
    public ExpressRouteFailoverSingleTestDetailsInner withEndTimeUtc(String endTimeUtc) {
        this.endTimeUtc = endTimeUtc;
        return this;
    }

    /**
     * Get the redundantRoutes property: List of routes received from this peering as well as some other peering
     * location.
     * 
     * @return the redundantRoutes value.
     */
    public List<ExpressRouteFailoverRedundantRoute> redundantRoutes() {
        return this.redundantRoutes;
    }

    /**
     * Set the redundantRoutes property: List of routes received from this peering as well as some other peering
     * location.
     * 
     * @param redundantRoutes the redundantRoutes value to set.
     * @return the ExpressRouteFailoverSingleTestDetailsInner object itself.
     */
    public ExpressRouteFailoverSingleTestDetailsInner
        withRedundantRoutes(List<ExpressRouteFailoverRedundantRoute> redundantRoutes) {
        this.redundantRoutes = redundantRoutes;
        return this;
    }

    /**
     * Get the nonRedundantRoutes property: List of al the routes that were received only from this peering location.
     * 
     * @return the nonRedundantRoutes value.
     */
    public List<String> nonRedundantRoutes() {
        return this.nonRedundantRoutes;
    }

    /**
     * Set the nonRedundantRoutes property: List of al the routes that were received only from this peering location.
     * 
     * @param nonRedundantRoutes the nonRedundantRoutes value to set.
     * @return the ExpressRouteFailoverSingleTestDetailsInner object itself.
     */
    public ExpressRouteFailoverSingleTestDetailsInner withNonRedundantRoutes(List<String> nonRedundantRoutes) {
        this.nonRedundantRoutes = nonRedundantRoutes;
        return this;
    }

    /**
     * Get the wasSimulationSuccessful property: Whether the failover simulation was successful or not.
     * 
     * @return the wasSimulationSuccessful value.
     */
    public Boolean wasSimulationSuccessful() {
        return this.wasSimulationSuccessful;
    }

    /**
     * Set the wasSimulationSuccessful property: Whether the failover simulation was successful or not.
     * 
     * @param wasSimulationSuccessful the wasSimulationSuccessful value to set.
     * @return the ExpressRouteFailoverSingleTestDetailsInner object itself.
     */
    public ExpressRouteFailoverSingleTestDetailsInner withWasSimulationSuccessful(Boolean wasSimulationSuccessful) {
        this.wasSimulationSuccessful = wasSimulationSuccessful;
        return this;
    }

    /**
     * Get the failoverConnectionDetails property: List of all the failover connections for this peering location.
     * 
     * @return the failoverConnectionDetails value.
     */
    public List<FailoverConnectionDetails> failoverConnectionDetails() {
        return this.failoverConnectionDetails;
    }

    /**
     * Set the failoverConnectionDetails property: List of all the failover connections for this peering location.
     * 
     * @param failoverConnectionDetails the failoverConnectionDetails value to set.
     * @return the ExpressRouteFailoverSingleTestDetailsInner object itself.
     */
    public ExpressRouteFailoverSingleTestDetailsInner
        withFailoverConnectionDetails(List<FailoverConnectionDetails> failoverConnectionDetails) {
        this.failoverConnectionDetails = failoverConnectionDetails;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (redundantRoutes() != null) {
            redundantRoutes().forEach(e -> e.validate());
        }
        if (failoverConnectionDetails() != null) {
            failoverConnectionDetails().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("peeringLocation", this.peeringLocation);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("startTimeUtc", this.startTimeUtc);
        jsonWriter.writeStringField("endTimeUtc", this.endTimeUtc);
        jsonWriter.writeArrayField("redundantRoutes", this.redundantRoutes,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("nonRedundantRoutes", this.nonRedundantRoutes,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("wasSimulationSuccessful", this.wasSimulationSuccessful);
        jsonWriter.writeArrayField("failoverConnectionDetails", this.failoverConnectionDetails,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExpressRouteFailoverSingleTestDetailsInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExpressRouteFailoverSingleTestDetailsInner if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExpressRouteFailoverSingleTestDetailsInner.
     */
    public static ExpressRouteFailoverSingleTestDetailsInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRouteFailoverSingleTestDetailsInner deserializedExpressRouteFailoverSingleTestDetailsInner
                = new ExpressRouteFailoverSingleTestDetailsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("peeringLocation".equals(fieldName)) {
                    deserializedExpressRouteFailoverSingleTestDetailsInner.peeringLocation = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedExpressRouteFailoverSingleTestDetailsInner.status
                        = FailoverTestStatusForSingleTest.fromString(reader.getString());
                } else if ("startTimeUtc".equals(fieldName)) {
                    deserializedExpressRouteFailoverSingleTestDetailsInner.startTimeUtc = reader.getString();
                } else if ("endTimeUtc".equals(fieldName)) {
                    deserializedExpressRouteFailoverSingleTestDetailsInner.endTimeUtc = reader.getString();
                } else if ("redundantRoutes".equals(fieldName)) {
                    List<ExpressRouteFailoverRedundantRoute> redundantRoutes
                        = reader.readArray(reader1 -> ExpressRouteFailoverRedundantRoute.fromJson(reader1));
                    deserializedExpressRouteFailoverSingleTestDetailsInner.redundantRoutes = redundantRoutes;
                } else if ("nonRedundantRoutes".equals(fieldName)) {
                    List<String> nonRedundantRoutes = reader.readArray(reader1 -> reader1.getString());
                    deserializedExpressRouteFailoverSingleTestDetailsInner.nonRedundantRoutes = nonRedundantRoutes;
                } else if ("wasSimulationSuccessful".equals(fieldName)) {
                    deserializedExpressRouteFailoverSingleTestDetailsInner.wasSimulationSuccessful
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("failoverConnectionDetails".equals(fieldName)) {
                    List<FailoverConnectionDetails> failoverConnectionDetails
                        = reader.readArray(reader1 -> FailoverConnectionDetails.fromJson(reader1));
                    deserializedExpressRouteFailoverSingleTestDetailsInner.failoverConnectionDetails
                        = failoverConnectionDetails;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExpressRouteFailoverSingleTestDetailsInner;
        });
    }
}
