// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ExpressRouteCircuitRoutesTableSummary;
import java.io.IOException;
import java.util.List;

/**
 * Response for ListRoutesTable associated with the Express Route Circuits API.
 */
@Fluent
public final class ExpressRouteCircuitsRoutesTableSummaryListResultInner
    implements JsonSerializable<ExpressRouteCircuitsRoutesTableSummaryListResultInner> {
    /*
     * A list of the routes table.
     */
    private List<ExpressRouteCircuitRoutesTableSummary> value;

    /*
     * The URL to get the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of ExpressRouteCircuitsRoutesTableSummaryListResultInner class.
     */
    public ExpressRouteCircuitsRoutesTableSummaryListResultInner() {
    }

    /**
     * Get the value property: A list of the routes table.
     * 
     * @return the value value.
     */
    public List<ExpressRouteCircuitRoutesTableSummary> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of the routes table.
     * 
     * @param value the value value to set.
     * @return the ExpressRouteCircuitsRoutesTableSummaryListResultInner object itself.
     */
    public ExpressRouteCircuitsRoutesTableSummaryListResultInner
        withValue(List<ExpressRouteCircuitRoutesTableSummary> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ExpressRouteCircuitsRoutesTableSummaryListResultInner object itself.
     */
    public ExpressRouteCircuitsRoutesTableSummaryListResultInner withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExpressRouteCircuitsRoutesTableSummaryListResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExpressRouteCircuitsRoutesTableSummaryListResultInner if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExpressRouteCircuitsRoutesTableSummaryListResultInner.
     */
    public static ExpressRouteCircuitsRoutesTableSummaryListResultInner fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRouteCircuitsRoutesTableSummaryListResultInner deserializedExpressRouteCircuitsRoutesTableSummaryListResultInner
                = new ExpressRouteCircuitsRoutesTableSummaryListResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ExpressRouteCircuitRoutesTableSummary> value
                        = reader.readArray(reader1 -> ExpressRouteCircuitRoutesTableSummary.fromJson(reader1));
                    deserializedExpressRouteCircuitsRoutesTableSummaryListResultInner.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedExpressRouteCircuitsRoutesTableSummaryListResultInner.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExpressRouteCircuitsRoutesTableSummaryListResultInner;
        });
    }
}
