// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.EffectiveNetworkSecurityGroup;
import java.io.IOException;
import java.util.List;

/**
 * Response for list effective network security groups API service call.
 */
@Fluent
public final class EffectiveNetworkSecurityGroupListResultInner
    implements JsonSerializable<EffectiveNetworkSecurityGroupListResultInner> {
    /*
     * A list of effective network security groups.
     */
    private List<EffectiveNetworkSecurityGroup> value;

    /*
     * The URL to get the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of EffectiveNetworkSecurityGroupListResultInner class.
     */
    public EffectiveNetworkSecurityGroupListResultInner() {
    }

    /**
     * Get the value property: A list of effective network security groups.
     * 
     * @return the value value.
     */
    public List<EffectiveNetworkSecurityGroup> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of effective network security groups.
     * 
     * @param value the value value to set.
     * @return the EffectiveNetworkSecurityGroupListResultInner object itself.
     */
    public EffectiveNetworkSecurityGroupListResultInner withValue(List<EffectiveNetworkSecurityGroup> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EffectiveNetworkSecurityGroupListResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EffectiveNetworkSecurityGroupListResultInner if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the EffectiveNetworkSecurityGroupListResultInner.
     */
    public static EffectiveNetworkSecurityGroupListResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EffectiveNetworkSecurityGroupListResultInner deserializedEffectiveNetworkSecurityGroupListResultInner
                = new EffectiveNetworkSecurityGroupListResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<EffectiveNetworkSecurityGroup> value
                        = reader.readArray(reader1 -> EffectiveNetworkSecurityGroup.fromJson(reader1));
                    deserializedEffectiveNetworkSecurityGroupListResultInner.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedEffectiveNetworkSecurityGroupListResultInner.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEffectiveNetworkSecurityGroupListResultInner;
        });
    }
}
